/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iotdata.model.UpdateThingShadowRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class UpdateThingShadowRequestMarshaller
implements Marshaller<Request<UpdateThingShadowRequest>, UpdateThingShadowRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<UpdateThingShadowRequest> marshall(UpdateThingShadowRequest updateThingShadowRequest) {
        if (updateThingShadowRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateThingShadowRequest, "AWSIotData");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/things/{thingName}/shadow";
        uriResourcePath = uriResourcePath.replace("{thingName}", updateThingShadowRequest.getThingName() != null ? StringUtils.fromString((String)updateThingShadowRequest.getThingName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)BinaryUtils.toStream((ByteBuffer)updateThingShadowRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

