/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.RejectCertificateTransferRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RejectCertificateTransferRequestMarshaller
implements Marshaller<Request<RejectCertificateTransferRequest>, RejectCertificateTransferRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RejectCertificateTransferRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RejectCertificateTransferRequest> marshall(RejectCertificateTransferRequest rejectCertificateTransferRequest) {
        if (rejectCertificateTransferRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rejectCertificateTransferRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/reject-certificate-transfer/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", rejectCertificateTransferRequest.getCertificateId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)rejectCertificateTransferRequest.getCertificateId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (rejectCertificateTransferRequest.getRejectReason() != null) {
                jsonGenerator.writeFieldName("rejectReason").writeValue(rejectCertificateTransferRequest.getRejectReason());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

