/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iot.model.AuthorizerSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAuthorizersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AuthorizerSummary> authorizers;
    private String nextMarker;

    public List<AuthorizerSummary> getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizers(Collection<AuthorizerSummary> authorizers) {
        if (authorizers == null) {
            this.authorizers = null;
            return;
        }
        this.authorizers = new ArrayList<AuthorizerSummary>(authorizers);
    }

    public ListAuthorizersResult withAuthorizers(AuthorizerSummary ... authorizers) {
        if (this.authorizers == null) {
            this.setAuthorizers(new ArrayList<AuthorizerSummary>(authorizers.length));
        }
        for (AuthorizerSummary ele : authorizers) {
            this.authorizers.add(ele);
        }
        return this;
    }

    public ListAuthorizersResult withAuthorizers(Collection<AuthorizerSummary> authorizers) {
        this.setAuthorizers(authorizers);
        return this;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListAuthorizersResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthorizers() != null) {
            sb.append("Authorizers: ").append(this.getAuthorizers()).append(",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: ").append(this.getNextMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuthorizersResult)) {
            return false;
        }
        ListAuthorizersResult other = (ListAuthorizersResult)obj;
        if (other.getAuthorizers() == null ^ this.getAuthorizers() == null) {
            return false;
        }
        if (other.getAuthorizers() != null && !other.getAuthorizers().equals(this.getAuthorizers())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        return other.getNextMarker() == null || other.getNextMarker().equals(this.getNextMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthorizers() == null ? 0 : this.getAuthorizers().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        return hashCode;
    }

    public ListAuthorizersResult clone() {
        try {
            return (ListAuthorizersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

