/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.AuthorizerStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UpdateAuthorizerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String authorizerName;
    private String authorizerFunctionArn;
    private String tokenKeyName;
    private Map<String, String> tokenSigningPublicKeys;
    private String status;
    private Boolean enableCachingForHttp;

    public void setAuthorizerName(String authorizerName) {
        this.authorizerName = authorizerName;
    }

    public String getAuthorizerName() {
        return this.authorizerName;
    }

    public UpdateAuthorizerRequest withAuthorizerName(String authorizerName) {
        this.setAuthorizerName(authorizerName);
        return this;
    }

    public void setAuthorizerFunctionArn(String authorizerFunctionArn) {
        this.authorizerFunctionArn = authorizerFunctionArn;
    }

    public String getAuthorizerFunctionArn() {
        return this.authorizerFunctionArn;
    }

    public UpdateAuthorizerRequest withAuthorizerFunctionArn(String authorizerFunctionArn) {
        this.setAuthorizerFunctionArn(authorizerFunctionArn);
        return this;
    }

    public void setTokenKeyName(String tokenKeyName) {
        this.tokenKeyName = tokenKeyName;
    }

    public String getTokenKeyName() {
        return this.tokenKeyName;
    }

    public UpdateAuthorizerRequest withTokenKeyName(String tokenKeyName) {
        this.setTokenKeyName(tokenKeyName);
        return this;
    }

    public Map<String, String> getTokenSigningPublicKeys() {
        return this.tokenSigningPublicKeys;
    }

    public void setTokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
        this.tokenSigningPublicKeys = tokenSigningPublicKeys;
    }

    public UpdateAuthorizerRequest withTokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
        this.setTokenSigningPublicKeys(tokenSigningPublicKeys);
        return this;
    }

    public UpdateAuthorizerRequest addTokenSigningPublicKeysEntry(String key, String value) {
        if (null == this.tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = new HashMap<String, String>();
        }
        if (this.tokenSigningPublicKeys.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tokenSigningPublicKeys.put(key, value);
        return this;
    }

    public UpdateAuthorizerRequest clearTokenSigningPublicKeysEntries() {
        this.tokenSigningPublicKeys = null;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public UpdateAuthorizerRequest withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public UpdateAuthorizerRequest withStatus(AuthorizerStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setEnableCachingForHttp(Boolean enableCachingForHttp) {
        this.enableCachingForHttp = enableCachingForHttp;
    }

    public Boolean getEnableCachingForHttp() {
        return this.enableCachingForHttp;
    }

    public UpdateAuthorizerRequest withEnableCachingForHttp(Boolean enableCachingForHttp) {
        this.setEnableCachingForHttp(enableCachingForHttp);
        return this;
    }

    public Boolean isEnableCachingForHttp() {
        return this.enableCachingForHttp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthorizerName() != null) {
            sb.append("AuthorizerName: ").append(this.getAuthorizerName()).append(",");
        }
        if (this.getAuthorizerFunctionArn() != null) {
            sb.append("AuthorizerFunctionArn: ").append(this.getAuthorizerFunctionArn()).append(",");
        }
        if (this.getTokenKeyName() != null) {
            sb.append("TokenKeyName: ").append(this.getTokenKeyName()).append(",");
        }
        if (this.getTokenSigningPublicKeys() != null) {
            sb.append("TokenSigningPublicKeys: ").append(this.getTokenSigningPublicKeys()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getEnableCachingForHttp() != null) {
            sb.append("EnableCachingForHttp: ").append(this.getEnableCachingForHttp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuthorizerRequest)) {
            return false;
        }
        UpdateAuthorizerRequest other = (UpdateAuthorizerRequest)obj;
        if (other.getAuthorizerName() == null ^ this.getAuthorizerName() == null) {
            return false;
        }
        if (other.getAuthorizerName() != null && !other.getAuthorizerName().equals(this.getAuthorizerName())) {
            return false;
        }
        if (other.getAuthorizerFunctionArn() == null ^ this.getAuthorizerFunctionArn() == null) {
            return false;
        }
        if (other.getAuthorizerFunctionArn() != null && !other.getAuthorizerFunctionArn().equals(this.getAuthorizerFunctionArn())) {
            return false;
        }
        if (other.getTokenKeyName() == null ^ this.getTokenKeyName() == null) {
            return false;
        }
        if (other.getTokenKeyName() != null && !other.getTokenKeyName().equals(this.getTokenKeyName())) {
            return false;
        }
        if (other.getTokenSigningPublicKeys() == null ^ this.getTokenSigningPublicKeys() == null) {
            return false;
        }
        if (other.getTokenSigningPublicKeys() != null && !other.getTokenSigningPublicKeys().equals(this.getTokenSigningPublicKeys())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getEnableCachingForHttp() == null ^ this.getEnableCachingForHttp() == null) {
            return false;
        }
        return other.getEnableCachingForHttp() == null || other.getEnableCachingForHttp().equals(this.getEnableCachingForHttp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthorizerName() == null ? 0 : this.getAuthorizerName().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizerFunctionArn() == null ? 0 : this.getAuthorizerFunctionArn().hashCode());
        hashCode = 31 * hashCode + (this.getTokenKeyName() == null ? 0 : this.getTokenKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getTokenSigningPublicKeys() == null ? 0 : this.getTokenSigningPublicKeys().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getEnableCachingForHttp() == null ? 0 : this.getEnableCachingForHttp().hashCode());
        return hashCode;
    }

    public UpdateAuthorizerRequest clone() {
        return (UpdateAuthorizerRequest)super.clone();
    }
}

