/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iotsitewise.model.ProjectSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListProjectsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ProjectSummary> projectSummaries;
    private String nextToken;

    public List<ProjectSummary> getProjectSummaries() {
        return this.projectSummaries;
    }

    public void setProjectSummaries(Collection<ProjectSummary> projectSummaries) {
        if (projectSummaries == null) {
            this.projectSummaries = null;
            return;
        }
        this.projectSummaries = new ArrayList<ProjectSummary>(projectSummaries);
    }

    public ListProjectsResult withProjectSummaries(ProjectSummary ... projectSummaries) {
        if (this.projectSummaries == null) {
            this.setProjectSummaries(new ArrayList<ProjectSummary>(projectSummaries.length));
        }
        for (ProjectSummary ele : projectSummaries) {
            this.projectSummaries.add(ele);
        }
        return this;
    }

    public ListProjectsResult withProjectSummaries(Collection<ProjectSummary> projectSummaries) {
        this.setProjectSummaries(projectSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListProjectsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProjectSummaries() != null) {
            sb.append("ProjectSummaries: ").append(this.getProjectSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResult)) {
            return false;
        }
        ListProjectsResult other = (ListProjectsResult)obj;
        if (other.getProjectSummaries() == null ^ this.getProjectSummaries() == null) {
            return false;
        }
        if (other.getProjectSummaries() != null && !other.getProjectSummaries().equals(this.getProjectSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProjectSummaries() == null ? 0 : this.getProjectSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListProjectsResult clone() {
        try {
            return (ListProjectsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

