/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.AggregationPeriod;
import com.amazonaws.services.iotwireless.model.Dimension;
import com.amazonaws.services.iotwireless.model.MetricName;
import com.amazonaws.services.iotwireless.model.transform.SummaryMetricQueryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SummaryMetricQuery
implements Serializable,
Cloneable,
StructuredPojo {
    private String queryId;
    private String metricName;
    private List<Dimension> dimensions;
    private String aggregationPeriod;
    private Date startTimestamp;
    private Date endTimestamp;

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public SummaryMetricQuery withQueryId(String queryId) {
        this.setQueryId(queryId);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public SummaryMetricQuery withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public SummaryMetricQuery withMetricName(MetricName metricName) {
        this.metricName = metricName.toString();
        return this;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new ArrayList<Dimension>(dimensions);
    }

    public SummaryMetricQuery withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new ArrayList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public SummaryMetricQuery withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setAggregationPeriod(String aggregationPeriod) {
        this.aggregationPeriod = aggregationPeriod;
    }

    public String getAggregationPeriod() {
        return this.aggregationPeriod;
    }

    public SummaryMetricQuery withAggregationPeriod(String aggregationPeriod) {
        this.setAggregationPeriod(aggregationPeriod);
        return this;
    }

    public SummaryMetricQuery withAggregationPeriod(AggregationPeriod aggregationPeriod) {
        this.aggregationPeriod = aggregationPeriod.toString();
        return this;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public SummaryMetricQuery withStartTimestamp(Date startTimestamp) {
        this.setStartTimestamp(startTimestamp);
        return this;
    }

    public void setEndTimestamp(Date endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public SummaryMetricQuery withEndTimestamp(Date endTimestamp) {
        this.setEndTimestamp(endTimestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueryId() != null) {
            sb.append("QueryId: ").append(this.getQueryId()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getAggregationPeriod() != null) {
            sb.append("AggregationPeriod: ").append(this.getAggregationPeriod()).append(",");
        }
        if (this.getStartTimestamp() != null) {
            sb.append("StartTimestamp: ").append(this.getStartTimestamp()).append(",");
        }
        if (this.getEndTimestamp() != null) {
            sb.append("EndTimestamp: ").append(this.getEndTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummaryMetricQuery)) {
            return false;
        }
        SummaryMetricQuery other = (SummaryMetricQuery)obj;
        if (other.getQueryId() == null ^ this.getQueryId() == null) {
            return false;
        }
        if (other.getQueryId() != null && !other.getQueryId().equals(this.getQueryId())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getAggregationPeriod() == null ^ this.getAggregationPeriod() == null) {
            return false;
        }
        if (other.getAggregationPeriod() != null && !other.getAggregationPeriod().equals(this.getAggregationPeriod())) {
            return false;
        }
        if (other.getStartTimestamp() == null ^ this.getStartTimestamp() == null) {
            return false;
        }
        if (other.getStartTimestamp() != null && !other.getStartTimestamp().equals(this.getStartTimestamp())) {
            return false;
        }
        if (other.getEndTimestamp() == null ^ this.getEndTimestamp() == null) {
            return false;
        }
        return other.getEndTimestamp() == null || other.getEndTimestamp().equals(this.getEndTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueryId() == null ? 0 : this.getQueryId().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationPeriod() == null ? 0 : this.getAggregationPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimestamp() == null ? 0 : this.getStartTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getEndTimestamp() == null ? 0 : this.getEndTimestamp().hashCode());
        return hashCode;
    }

    public SummaryMetricQuery clone() {
        try {
            return (SummaryMetricQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SummaryMetricQueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

