/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotwireless.model.CellTowers;
import java.util.List;

@SdkInternalApi
public class CellTowersMarshaller {
    private static final MarshallingInfo<List> GSM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Gsm").build();
    private static final MarshallingInfo<List> WCDMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Wcdma").build();
    private static final MarshallingInfo<List> TDSCDMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tdscdma").build();
    private static final MarshallingInfo<List> LTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lte").build();
    private static final MarshallingInfo<List> CDMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Cdma").build();
    private static final CellTowersMarshaller instance = new CellTowersMarshaller();

    public static CellTowersMarshaller getInstance() {
        return instance;
    }

    public void marshall(CellTowers cellTowers, ProtocolMarshaller protocolMarshaller) {
        if (cellTowers == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(cellTowers.getGsm(), GSM_BINDING);
            protocolMarshaller.marshall(cellTowers.getWcdma(), WCDMA_BINDING);
            protocolMarshaller.marshall(cellTowers.getTdscdma(), TDSCDMA_BINDING);
            protocolMarshaller.marshall(cellTowers.getLte(), LTE_BINDING);
            protocolMarshaller.marshall(cellTowers.getCdma(), CDMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

