/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.transform.S3BucketDefinitionForJobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3BucketDefinitionForJob
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private List<String> buckets;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public S3BucketDefinitionForJob withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public List<String> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Collection<String> buckets) {
        if (buckets == null) {
            this.buckets = null;
            return;
        }
        this.buckets = new ArrayList<String>(buckets);
    }

    public S3BucketDefinitionForJob withBuckets(String ... buckets) {
        if (this.buckets == null) {
            this.setBuckets(new ArrayList<String>(buckets.length));
        }
        for (String ele : buckets) {
            this.buckets.add(ele);
        }
        return this;
    }

    public S3BucketDefinitionForJob withBuckets(Collection<String> buckets) {
        this.setBuckets(buckets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getBuckets() != null) {
            sb.append("Buckets: ").append(this.getBuckets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketDefinitionForJob)) {
            return false;
        }
        S3BucketDefinitionForJob other = (S3BucketDefinitionForJob)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getBuckets() == null ^ this.getBuckets() == null) {
            return false;
        }
        return other.getBuckets() == null || other.getBuckets().equals(this.getBuckets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getBuckets() == null ? 0 : this.getBuckets().hashCode());
        return hashCode;
    }

    public S3BucketDefinitionForJob clone() {
        try {
            return (S3BucketDefinitionForJob)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3BucketDefinitionForJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

