/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptunedata.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.neptunedata.model.GremlinQueryStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListOpenCypherQueriesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Integer acceptedQueryCount;
    private Integer runningQueryCount;
    private List<GremlinQueryStatus> queries;

    public void setAcceptedQueryCount(Integer acceptedQueryCount) {
        this.acceptedQueryCount = acceptedQueryCount;
    }

    public Integer getAcceptedQueryCount() {
        return this.acceptedQueryCount;
    }

    public ListOpenCypherQueriesResult withAcceptedQueryCount(Integer acceptedQueryCount) {
        this.setAcceptedQueryCount(acceptedQueryCount);
        return this;
    }

    public void setRunningQueryCount(Integer runningQueryCount) {
        this.runningQueryCount = runningQueryCount;
    }

    public Integer getRunningQueryCount() {
        return this.runningQueryCount;
    }

    public ListOpenCypherQueriesResult withRunningQueryCount(Integer runningQueryCount) {
        this.setRunningQueryCount(runningQueryCount);
        return this;
    }

    public List<GremlinQueryStatus> getQueries() {
        return this.queries;
    }

    public void setQueries(Collection<GremlinQueryStatus> queries) {
        if (queries == null) {
            this.queries = null;
            return;
        }
        this.queries = new ArrayList<GremlinQueryStatus>(queries);
    }

    public ListOpenCypherQueriesResult withQueries(GremlinQueryStatus ... queries) {
        if (this.queries == null) {
            this.setQueries(new ArrayList<GremlinQueryStatus>(queries.length));
        }
        for (GremlinQueryStatus ele : queries) {
            this.queries.add(ele);
        }
        return this;
    }

    public ListOpenCypherQueriesResult withQueries(Collection<GremlinQueryStatus> queries) {
        this.setQueries(queries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceptedQueryCount() != null) {
            sb.append("AcceptedQueryCount: ").append(this.getAcceptedQueryCount()).append(",");
        }
        if (this.getRunningQueryCount() != null) {
            sb.append("RunningQueryCount: ").append(this.getRunningQueryCount()).append(",");
        }
        if (this.getQueries() != null) {
            sb.append("Queries: ").append(this.getQueries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenCypherQueriesResult)) {
            return false;
        }
        ListOpenCypherQueriesResult other = (ListOpenCypherQueriesResult)obj;
        if (other.getAcceptedQueryCount() == null ^ this.getAcceptedQueryCount() == null) {
            return false;
        }
        if (other.getAcceptedQueryCount() != null && !other.getAcceptedQueryCount().equals(this.getAcceptedQueryCount())) {
            return false;
        }
        if (other.getRunningQueryCount() == null ^ this.getRunningQueryCount() == null) {
            return false;
        }
        if (other.getRunningQueryCount() != null && !other.getRunningQueryCount().equals(this.getRunningQueryCount())) {
            return false;
        }
        if (other.getQueries() == null ^ this.getQueries() == null) {
            return false;
        }
        return other.getQueries() == null || other.getQueries().equals(this.getQueries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceptedQueryCount() == null ? 0 : this.getAcceptedQueryCount().hashCode());
        hashCode = 31 * hashCode + (this.getRunningQueryCount() == null ? 0 : this.getRunningQueryCount().hashCode());
        hashCode = 31 * hashCode + (this.getQueries() == null ? 0 : this.getQueries().hashCode());
        return hashCode;
    }

    public ListOpenCypherQueriesResult clone() {
        try {
            return (ListOpenCypherQueriesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

