/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.CreateDeploymentRequest;
import com.amazonaws.services.opsworks.model.transform.DeploymentCommandJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateDeploymentRequestMarshaller
implements Marshaller<Request<CreateDeploymentRequest>, CreateDeploymentRequest> {
    public Request<CreateDeploymentRequest> marshall(CreateDeploymentRequest createDeploymentRequest) {
        if (createDeploymentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDeploymentRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CreateDeployment");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList instanceIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createDeploymentRequest.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)createDeploymentRequest.getStackId());
            }
            if (createDeploymentRequest.getAppId() != null) {
                jsonWriter.key("AppId").value((Object)createDeploymentRequest.getAppId());
            }
            if (!(instanceIdsList = (SdkInternalList)createDeploymentRequest.getInstanceIds()).isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonWriter.key("InstanceIds");
                jsonWriter.array();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonWriter.value((Object)instanceIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (createDeploymentRequest.getCommand() != null) {
                jsonWriter.key("Command");
                DeploymentCommandJsonMarshaller.getInstance().marshall(createDeploymentRequest.getCommand(), jsonWriter);
            }
            if (createDeploymentRequest.getComment() != null) {
                jsonWriter.key("Comment").value((Object)createDeploymentRequest.getComment());
            }
            if (createDeploymentRequest.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value((Object)createDeploymentRequest.getCustomJson());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

