/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.CreateAppRequest;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.EnvironmentVariable;
import com.amazonaws.services.opsworks.model.transform.DataSourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.EnvironmentVariableJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SslConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class CreateAppRequestMarshaller
implements Marshaller<Request<CreateAppRequest>, CreateAppRequest> {
    public Request<CreateAppRequest> marshall(CreateAppRequest createAppRequest) {
        if (createAppRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAppRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CreateApp");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList environmentList;
            SdkInternalMap attributesMap;
            SdkInternalList domainsList;
            SdkInternalList dataSourcesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createAppRequest.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)createAppRequest.getStackId());
            }
            if (createAppRequest.getShortname() != null) {
                jsonWriter.key("Shortname").value((Object)createAppRequest.getShortname());
            }
            if (createAppRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)createAppRequest.getName());
            }
            if (createAppRequest.getDescription() != null) {
                jsonWriter.key("Description").value((Object)createAppRequest.getDescription());
            }
            if (!(dataSourcesList = (SdkInternalList)createAppRequest.getDataSources()).isEmpty() || !dataSourcesList.isAutoConstruct()) {
                jsonWriter.key("DataSources");
                jsonWriter.array();
                for (DataSource dataSourcesListValue : dataSourcesList) {
                    if (dataSourcesListValue == null) continue;
                    DataSourceJsonMarshaller.getInstance().marshall(dataSourcesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createAppRequest.getType() != null) {
                jsonWriter.key("Type").value((Object)createAppRequest.getType());
            }
            if (createAppRequest.getAppSource() != null) {
                jsonWriter.key("AppSource");
                SourceJsonMarshaller.getInstance().marshall(createAppRequest.getAppSource(), jsonWriter);
            }
            if (!(domainsList = (SdkInternalList)createAppRequest.getDomains()).isEmpty() || !domainsList.isAutoConstruct()) {
                jsonWriter.key("Domains");
                jsonWriter.array();
                for (String domainsListValue : domainsList) {
                    if (domainsListValue == null) continue;
                    jsonWriter.value((Object)domainsListValue);
                }
                jsonWriter.endArray();
            }
            if (createAppRequest.getEnableSsl() != null) {
                jsonWriter.key("EnableSsl").value((Object)createAppRequest.getEnableSsl());
            }
            if (createAppRequest.getSslConfiguration() != null) {
                jsonWriter.key("SslConfiguration");
                SslConfigurationJsonMarshaller.getInstance().marshall(createAppRequest.getSslConfiguration(), jsonWriter);
            }
            if (!(attributesMap = (SdkInternalMap)createAppRequest.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!(environmentList = (SdkInternalList)createAppRequest.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonWriter.key("Environment");
                jsonWriter.array();
                for (EnvironmentVariable environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    EnvironmentVariableJsonMarshaller.getInstance().marshall(environmentListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

