/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.ElasticLoadBalancer;
import com.amazonaws.util.json.SdkJsonGenerator;

public class ElasticLoadBalancerJsonMarshaller {
    private static ElasticLoadBalancerJsonMarshaller instance;

    public void marshall(ElasticLoadBalancer elasticLoadBalancer, SdkJsonGenerator jsonGenerator) {
        if (elasticLoadBalancer == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList ec2InstanceIdsList;
            SdkInternalList subnetIdsList;
            SdkInternalList availabilityZonesList;
            jsonGenerator.writeStartObject();
            if (elasticLoadBalancer.getElasticLoadBalancerName() != null) {
                jsonGenerator.writeFieldName("ElasticLoadBalancerName").writeValue(elasticLoadBalancer.getElasticLoadBalancerName());
            }
            if (elasticLoadBalancer.getRegion() != null) {
                jsonGenerator.writeFieldName("Region").writeValue(elasticLoadBalancer.getRegion());
            }
            if (elasticLoadBalancer.getDnsName() != null) {
                jsonGenerator.writeFieldName("DnsName").writeValue(elasticLoadBalancer.getDnsName());
            }
            if (elasticLoadBalancer.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(elasticLoadBalancer.getStackId());
            }
            if (elasticLoadBalancer.getLayerId() != null) {
                jsonGenerator.writeFieldName("LayerId").writeValue(elasticLoadBalancer.getLayerId());
            }
            if (elasticLoadBalancer.getVpcId() != null) {
                jsonGenerator.writeFieldName("VpcId").writeValue(elasticLoadBalancer.getVpcId());
            }
            if (!(availabilityZonesList = (SdkInternalList)elasticLoadBalancer.getAvailabilityZones()).isEmpty() || !availabilityZonesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("AvailabilityZones");
                jsonGenerator.writeStartArray();
                for (String availabilityZonesListValue : availabilityZonesList) {
                    if (availabilityZonesListValue == null) continue;
                    jsonGenerator.writeValue(availabilityZonesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(subnetIdsList = (SdkInternalList)elasticLoadBalancer.getSubnetIds()).isEmpty() || !subnetIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(ec2InstanceIdsList = (SdkInternalList)elasticLoadBalancer.getEc2InstanceIds()).isEmpty() || !ec2InstanceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Ec2InstanceIds");
                jsonGenerator.writeStartArray();
                for (String ec2InstanceIdsListValue : ec2InstanceIdsList) {
                    if (ec2InstanceIdsListValue == null) continue;
                    jsonGenerator.writeValue(ec2InstanceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ElasticLoadBalancerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ElasticLoadBalancerJsonMarshaller();
        }
        return instance;
    }
}

