/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.DescribeRaidArraysRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeRaidArraysRequestMarshaller
implements Marshaller<Request<DescribeRaidArraysRequest>, DescribeRaidArraysRequest> {
    public Request<DescribeRaidArraysRequest> marshall(DescribeRaidArraysRequest describeRaidArraysRequest) {
        if (describeRaidArraysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRaidArraysRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeRaidArrays");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList raidArrayIdsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (describeRaidArraysRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(describeRaidArraysRequest.getInstanceId());
            }
            if (describeRaidArraysRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(describeRaidArraysRequest.getStackId());
            }
            if (!(raidArrayIdsList = (SdkInternalList)describeRaidArraysRequest.getRaidArrayIds()).isEmpty() || !raidArrayIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("RaidArrayIds");
                jsonGenerator.writeStartArray();
                for (String raidArrayIdsListValue : raidArrayIdsList) {
                    if (raidArrayIdsListValue == null) continue;
                    jsonGenerator.writeValue(raidArrayIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

