/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.outposts.AWSOutposts;
import com.amazonaws.services.outposts.AWSOutpostsClientBuilder;
import com.amazonaws.services.outposts.model.AWSOutpostsException;
import com.amazonaws.services.outposts.model.CancelCapacityTaskRequest;
import com.amazonaws.services.outposts.model.CancelCapacityTaskResult;
import com.amazonaws.services.outposts.model.CancelOrderRequest;
import com.amazonaws.services.outposts.model.CancelOrderResult;
import com.amazonaws.services.outposts.model.CreateOrderRequest;
import com.amazonaws.services.outposts.model.CreateOrderResult;
import com.amazonaws.services.outposts.model.CreateOutpostRequest;
import com.amazonaws.services.outposts.model.CreateOutpostResult;
import com.amazonaws.services.outposts.model.CreateSiteRequest;
import com.amazonaws.services.outposts.model.CreateSiteResult;
import com.amazonaws.services.outposts.model.DeleteOutpostRequest;
import com.amazonaws.services.outposts.model.DeleteOutpostResult;
import com.amazonaws.services.outposts.model.DeleteSiteRequest;
import com.amazonaws.services.outposts.model.DeleteSiteResult;
import com.amazonaws.services.outposts.model.GetCapacityTaskRequest;
import com.amazonaws.services.outposts.model.GetCapacityTaskResult;
import com.amazonaws.services.outposts.model.GetCatalogItemRequest;
import com.amazonaws.services.outposts.model.GetCatalogItemResult;
import com.amazonaws.services.outposts.model.GetConnectionRequest;
import com.amazonaws.services.outposts.model.GetConnectionResult;
import com.amazonaws.services.outposts.model.GetOrderRequest;
import com.amazonaws.services.outposts.model.GetOrderResult;
import com.amazonaws.services.outposts.model.GetOutpostInstanceTypesRequest;
import com.amazonaws.services.outposts.model.GetOutpostInstanceTypesResult;
import com.amazonaws.services.outposts.model.GetOutpostRequest;
import com.amazonaws.services.outposts.model.GetOutpostResult;
import com.amazonaws.services.outposts.model.GetOutpostSupportedInstanceTypesRequest;
import com.amazonaws.services.outposts.model.GetOutpostSupportedInstanceTypesResult;
import com.amazonaws.services.outposts.model.GetSiteAddressRequest;
import com.amazonaws.services.outposts.model.GetSiteAddressResult;
import com.amazonaws.services.outposts.model.GetSiteRequest;
import com.amazonaws.services.outposts.model.GetSiteResult;
import com.amazonaws.services.outposts.model.ListAssetsRequest;
import com.amazonaws.services.outposts.model.ListAssetsResult;
import com.amazonaws.services.outposts.model.ListCapacityTasksRequest;
import com.amazonaws.services.outposts.model.ListCapacityTasksResult;
import com.amazonaws.services.outposts.model.ListCatalogItemsRequest;
import com.amazonaws.services.outposts.model.ListCatalogItemsResult;
import com.amazonaws.services.outposts.model.ListOrdersRequest;
import com.amazonaws.services.outposts.model.ListOrdersResult;
import com.amazonaws.services.outposts.model.ListOutpostsRequest;
import com.amazonaws.services.outposts.model.ListOutpostsResult;
import com.amazonaws.services.outposts.model.ListSitesRequest;
import com.amazonaws.services.outposts.model.ListSitesResult;
import com.amazonaws.services.outposts.model.ListTagsForResourceRequest;
import com.amazonaws.services.outposts.model.ListTagsForResourceResult;
import com.amazonaws.services.outposts.model.StartCapacityTaskRequest;
import com.amazonaws.services.outposts.model.StartCapacityTaskResult;
import com.amazonaws.services.outposts.model.StartConnectionRequest;
import com.amazonaws.services.outposts.model.StartConnectionResult;
import com.amazonaws.services.outposts.model.TagResourceRequest;
import com.amazonaws.services.outposts.model.TagResourceResult;
import com.amazonaws.services.outposts.model.UntagResourceRequest;
import com.amazonaws.services.outposts.model.UntagResourceResult;
import com.amazonaws.services.outposts.model.UpdateOutpostRequest;
import com.amazonaws.services.outposts.model.UpdateOutpostResult;
import com.amazonaws.services.outposts.model.UpdateSiteAddressRequest;
import com.amazonaws.services.outposts.model.UpdateSiteAddressResult;
import com.amazonaws.services.outposts.model.UpdateSiteRackPhysicalPropertiesRequest;
import com.amazonaws.services.outposts.model.UpdateSiteRackPhysicalPropertiesResult;
import com.amazonaws.services.outposts.model.UpdateSiteRequest;
import com.amazonaws.services.outposts.model.UpdateSiteResult;
import com.amazonaws.services.outposts.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.outposts.model.transform.CancelCapacityTaskRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.CancelCapacityTaskResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.CancelOrderRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.CancelOrderResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.outposts.model.transform.CreateOrderRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.CreateOrderResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.CreateOutpostRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.CreateOutpostResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.CreateSiteRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.CreateSiteResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.DeleteOutpostRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.DeleteOutpostResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.DeleteSiteRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.DeleteSiteResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.GetCapacityTaskRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.GetCapacityTaskResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.GetCatalogItemRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.GetCatalogItemResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.GetConnectionRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.GetConnectionResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.GetOrderRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.GetOrderResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.GetOutpostInstanceTypesRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.GetOutpostInstanceTypesResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.GetOutpostRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.GetOutpostResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.GetOutpostSupportedInstanceTypesRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.GetOutpostSupportedInstanceTypesResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.GetSiteAddressRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.GetSiteAddressResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.GetSiteRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.GetSiteResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ListAssetsRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.ListAssetsResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ListCapacityTasksRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.ListCapacityTasksResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ListCatalogItemsRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.ListCatalogItemsResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ListOrdersRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.ListOrdersResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ListOutpostsRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.ListOutpostsResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ListSitesRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.ListSitesResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.outposts.model.transform.StartCapacityTaskRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.StartCapacityTaskResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.StartConnectionRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.StartConnectionResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.UpdateOutpostRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.UpdateOutpostResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.UpdateSiteAddressRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.UpdateSiteAddressResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.UpdateSiteRackPhysicalPropertiesRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.UpdateSiteRackPhysicalPropertiesResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.UpdateSiteRequestProtocolMarshaller;
import com.amazonaws.services.outposts.model.transform.UpdateSiteResultJsonUnmarshaller;
import com.amazonaws.services.outposts.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSOutpostsClient
extends AmazonWebServiceClient
implements AWSOutposts {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSOutposts.class);
    private static final String DEFAULT_SIGNING_NAME = "outposts";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSOutpostsException.class));

    public static AWSOutpostsClientBuilder builder() {
        return AWSOutpostsClientBuilder.standard();
    }

    AWSOutpostsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSOutpostsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("outposts.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/outposts/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/outposts/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelCapacityTaskResult cancelCapacityTask(CancelCapacityTaskRequest request) {
        request = (CancelCapacityTaskRequest)this.beforeClientExecution(request);
        return this.executeCancelCapacityTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelCapacityTaskResult executeCancelCapacityTask(CancelCapacityTaskRequest cancelCapacityTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelCapacityTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelCapacityTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelCapacityTaskRequestProtocolMarshaller(protocolFactory).marshall((CancelCapacityTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelCapacityTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelCapacityTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelCapacityTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelCapacityTaskResult cancelCapacityTaskResult = (CancelCapacityTaskResult)response.getAwsResponse();
            return cancelCapacityTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CancelOrderResult cancelOrder(CancelOrderRequest request) {
        request = (CancelOrderRequest)this.beforeClientExecution(request);
        return this.executeCancelOrder(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelOrderResult executeCancelOrder(CancelOrderRequest cancelOrderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelOrderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelOrderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelOrderRequestProtocolMarshaller(protocolFactory).marshall((CancelOrderRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelOrderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelOrder");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelOrderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelOrderResult cancelOrderResult = (CancelOrderResult)response.getAwsResponse();
            return cancelOrderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateOrderResult createOrder(CreateOrderRequest request) {
        request = (CreateOrderRequest)this.beforeClientExecution(request);
        return this.executeCreateOrder(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateOrderResult executeCreateOrder(CreateOrderRequest createOrderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createOrderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateOrderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateOrderRequestProtocolMarshaller(protocolFactory).marshall((CreateOrderRequest)super.beforeMarshalling((AmazonWebServiceRequest)createOrderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateOrder");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateOrderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateOrderResult createOrderResult = (CreateOrderResult)response.getAwsResponse();
            return createOrderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateOutpostResult createOutpost(CreateOutpostRequest request) {
        request = (CreateOutpostRequest)this.beforeClientExecution(request);
        return this.executeCreateOutpost(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateOutpostResult executeCreateOutpost(CreateOutpostRequest createOutpostRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createOutpostRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateOutpostRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateOutpostRequestProtocolMarshaller(protocolFactory).marshall((CreateOutpostRequest)super.beforeMarshalling((AmazonWebServiceRequest)createOutpostRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateOutpost");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateOutpostResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateOutpostResult createOutpostResult = (CreateOutpostResult)response.getAwsResponse();
            return createOutpostResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSiteResult createSite(CreateSiteRequest request) {
        request = (CreateSiteRequest)this.beforeClientExecution(request);
        return this.executeCreateSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSiteResult executeCreateSite(CreateSiteRequest createSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSiteRequestProtocolMarshaller(protocolFactory).marshall((CreateSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSiteResult createSiteResult = (CreateSiteResult)response.getAwsResponse();
            return createSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteOutpostResult deleteOutpost(DeleteOutpostRequest request) {
        request = (DeleteOutpostRequest)this.beforeClientExecution(request);
        return this.executeDeleteOutpost(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteOutpostResult executeDeleteOutpost(DeleteOutpostRequest deleteOutpostRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteOutpostRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteOutpostRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteOutpostRequestProtocolMarshaller(protocolFactory).marshall((DeleteOutpostRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteOutpostRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteOutpost");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteOutpostResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteOutpostResult deleteOutpostResult = (DeleteOutpostResult)response.getAwsResponse();
            return deleteOutpostResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSiteResult deleteSite(DeleteSiteRequest request) {
        request = (DeleteSiteRequest)this.beforeClientExecution(request);
        return this.executeDeleteSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSiteResult executeDeleteSite(DeleteSiteRequest deleteSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSiteRequestProtocolMarshaller(protocolFactory).marshall((DeleteSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSiteResult deleteSiteResult = (DeleteSiteResult)response.getAwsResponse();
            return deleteSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCapacityTaskResult getCapacityTask(GetCapacityTaskRequest request) {
        request = (GetCapacityTaskRequest)this.beforeClientExecution(request);
        return this.executeGetCapacityTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCapacityTaskResult executeGetCapacityTask(GetCapacityTaskRequest getCapacityTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCapacityTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCapacityTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCapacityTaskRequestProtocolMarshaller(protocolFactory).marshall((GetCapacityTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCapacityTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCapacityTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCapacityTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCapacityTaskResult getCapacityTaskResult = (GetCapacityTaskResult)response.getAwsResponse();
            return getCapacityTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCatalogItemResult getCatalogItem(GetCatalogItemRequest request) {
        request = (GetCatalogItemRequest)this.beforeClientExecution(request);
        return this.executeGetCatalogItem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCatalogItemResult executeGetCatalogItem(GetCatalogItemRequest getCatalogItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCatalogItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCatalogItemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCatalogItemRequestProtocolMarshaller(protocolFactory).marshall((GetCatalogItemRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCatalogItemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCatalogItem");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCatalogItemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCatalogItemResult getCatalogItemResult = (GetCatalogItemResult)response.getAwsResponse();
            return getCatalogItemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetConnectionResult getConnection(GetConnectionRequest request) {
        request = (GetConnectionRequest)this.beforeClientExecution(request);
        return this.executeGetConnection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetConnectionResult executeGetConnection(GetConnectionRequest getConnectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetConnectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetConnectionRequestProtocolMarshaller(protocolFactory).marshall((GetConnectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getConnectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetConnection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetConnectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetConnectionResult getConnectionResult = (GetConnectionResult)response.getAwsResponse();
            return getConnectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOrderResult getOrder(GetOrderRequest request) {
        request = (GetOrderRequest)this.beforeClientExecution(request);
        return this.executeGetOrder(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOrderResult executeGetOrder(GetOrderRequest getOrderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOrderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOrderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOrderRequestProtocolMarshaller(protocolFactory).marshall((GetOrderRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOrderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOrder");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOrderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOrderResult getOrderResult = (GetOrderResult)response.getAwsResponse();
            return getOrderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOutpostResult getOutpost(GetOutpostRequest request) {
        request = (GetOutpostRequest)this.beforeClientExecution(request);
        return this.executeGetOutpost(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOutpostResult executeGetOutpost(GetOutpostRequest getOutpostRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOutpostRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOutpostRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOutpostRequestProtocolMarshaller(protocolFactory).marshall((GetOutpostRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOutpostRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOutpost");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOutpostResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOutpostResult getOutpostResult = (GetOutpostResult)response.getAwsResponse();
            return getOutpostResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOutpostInstanceTypesResult getOutpostInstanceTypes(GetOutpostInstanceTypesRequest request) {
        request = (GetOutpostInstanceTypesRequest)this.beforeClientExecution(request);
        return this.executeGetOutpostInstanceTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOutpostInstanceTypesResult executeGetOutpostInstanceTypes(GetOutpostInstanceTypesRequest getOutpostInstanceTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOutpostInstanceTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOutpostInstanceTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOutpostInstanceTypesRequestProtocolMarshaller(protocolFactory).marshall((GetOutpostInstanceTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOutpostInstanceTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOutpostInstanceTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOutpostInstanceTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOutpostInstanceTypesResult getOutpostInstanceTypesResult = (GetOutpostInstanceTypesResult)response.getAwsResponse();
            return getOutpostInstanceTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOutpostSupportedInstanceTypesResult getOutpostSupportedInstanceTypes(GetOutpostSupportedInstanceTypesRequest request) {
        request = (GetOutpostSupportedInstanceTypesRequest)this.beforeClientExecution(request);
        return this.executeGetOutpostSupportedInstanceTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOutpostSupportedInstanceTypesResult executeGetOutpostSupportedInstanceTypes(GetOutpostSupportedInstanceTypesRequest getOutpostSupportedInstanceTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOutpostSupportedInstanceTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOutpostSupportedInstanceTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOutpostSupportedInstanceTypesRequestProtocolMarshaller(protocolFactory).marshall((GetOutpostSupportedInstanceTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOutpostSupportedInstanceTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOutpostSupportedInstanceTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOutpostSupportedInstanceTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOutpostSupportedInstanceTypesResult getOutpostSupportedInstanceTypesResult = (GetOutpostSupportedInstanceTypesResult)response.getAwsResponse();
            return getOutpostSupportedInstanceTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSiteResult getSite(GetSiteRequest request) {
        request = (GetSiteRequest)this.beforeClientExecution(request);
        return this.executeGetSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSiteResult executeGetSite(GetSiteRequest getSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSiteRequestProtocolMarshaller(protocolFactory).marshall((GetSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSiteResult getSiteResult = (GetSiteResult)response.getAwsResponse();
            return getSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSiteAddressResult getSiteAddress(GetSiteAddressRequest request) {
        request = (GetSiteAddressRequest)this.beforeClientExecution(request);
        return this.executeGetSiteAddress(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSiteAddressResult executeGetSiteAddress(GetSiteAddressRequest getSiteAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSiteAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSiteAddressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSiteAddressRequestProtocolMarshaller(protocolFactory).marshall((GetSiteAddressRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSiteAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSiteAddress");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSiteAddressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSiteAddressResult getSiteAddressResult = (GetSiteAddressResult)response.getAwsResponse();
            return getSiteAddressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAssetsResult listAssets(ListAssetsRequest request) {
        request = (ListAssetsRequest)this.beforeClientExecution(request);
        return this.executeListAssets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAssetsResult executeListAssets(ListAssetsRequest listAssetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssetsRequestProtocolMarshaller(protocolFactory).marshall((ListAssetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAssets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssetsResult listAssetsResult = (ListAssetsResult)response.getAwsResponse();
            return listAssetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCapacityTasksResult listCapacityTasks(ListCapacityTasksRequest request) {
        request = (ListCapacityTasksRequest)this.beforeClientExecution(request);
        return this.executeListCapacityTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCapacityTasksResult executeListCapacityTasks(ListCapacityTasksRequest listCapacityTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCapacityTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCapacityTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCapacityTasksRequestProtocolMarshaller(protocolFactory).marshall((ListCapacityTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCapacityTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCapacityTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCapacityTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCapacityTasksResult listCapacityTasksResult = (ListCapacityTasksResult)response.getAwsResponse();
            return listCapacityTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCatalogItemsResult listCatalogItems(ListCatalogItemsRequest request) {
        request = (ListCatalogItemsRequest)this.beforeClientExecution(request);
        return this.executeListCatalogItems(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCatalogItemsResult executeListCatalogItems(ListCatalogItemsRequest listCatalogItemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCatalogItemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCatalogItemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCatalogItemsRequestProtocolMarshaller(protocolFactory).marshall((ListCatalogItemsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCatalogItemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCatalogItems");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCatalogItemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCatalogItemsResult listCatalogItemsResult = (ListCatalogItemsResult)response.getAwsResponse();
            return listCatalogItemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOrdersResult listOrders(ListOrdersRequest request) {
        request = (ListOrdersRequest)this.beforeClientExecution(request);
        return this.executeListOrders(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOrdersResult executeListOrders(ListOrdersRequest listOrdersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOrdersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOrdersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOrdersRequestProtocolMarshaller(protocolFactory).marshall((ListOrdersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOrdersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOrders");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOrdersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOrdersResult listOrdersResult = (ListOrdersResult)response.getAwsResponse();
            return listOrdersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOutpostsResult listOutposts(ListOutpostsRequest request) {
        request = (ListOutpostsRequest)this.beforeClientExecution(request);
        return this.executeListOutposts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOutpostsResult executeListOutposts(ListOutpostsRequest listOutpostsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOutpostsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOutpostsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOutpostsRequestProtocolMarshaller(protocolFactory).marshall((ListOutpostsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOutpostsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOutposts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOutpostsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOutpostsResult listOutpostsResult = (ListOutpostsResult)response.getAwsResponse();
            return listOutpostsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSitesResult listSites(ListSitesRequest request) {
        request = (ListSitesRequest)this.beforeClientExecution(request);
        return this.executeListSites(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSitesResult executeListSites(ListSitesRequest listSitesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSitesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSitesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSitesRequestProtocolMarshaller(protocolFactory).marshall((ListSitesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSitesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSites");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSitesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSitesResult listSitesResult = (ListSitesResult)response.getAwsResponse();
            return listSitesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartCapacityTaskResult startCapacityTask(StartCapacityTaskRequest request) {
        request = (StartCapacityTaskRequest)this.beforeClientExecution(request);
        return this.executeStartCapacityTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartCapacityTaskResult executeStartCapacityTask(StartCapacityTaskRequest startCapacityTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startCapacityTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartCapacityTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartCapacityTaskRequestProtocolMarshaller(protocolFactory).marshall((StartCapacityTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)startCapacityTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartCapacityTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartCapacityTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartCapacityTaskResult startCapacityTaskResult = (StartCapacityTaskResult)response.getAwsResponse();
            return startCapacityTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartConnectionResult startConnection(StartConnectionRequest request) {
        request = (StartConnectionRequest)this.beforeClientExecution(request);
        return this.executeStartConnection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartConnectionResult executeStartConnection(StartConnectionRequest startConnectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartConnectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartConnectionRequestProtocolMarshaller(protocolFactory).marshall((StartConnectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startConnectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartConnection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartConnectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartConnectionResult startConnectionResult = (StartConnectionResult)response.getAwsResponse();
            return startConnectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateOutpostResult updateOutpost(UpdateOutpostRequest request) {
        request = (UpdateOutpostRequest)this.beforeClientExecution(request);
        return this.executeUpdateOutpost(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateOutpostResult executeUpdateOutpost(UpdateOutpostRequest updateOutpostRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateOutpostRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateOutpostRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateOutpostRequestProtocolMarshaller(protocolFactory).marshall((UpdateOutpostRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateOutpostRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateOutpost");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateOutpostResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateOutpostResult updateOutpostResult = (UpdateOutpostResult)response.getAwsResponse();
            return updateOutpostResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSiteResult updateSite(UpdateSiteRequest request) {
        request = (UpdateSiteRequest)this.beforeClientExecution(request);
        return this.executeUpdateSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSiteResult executeUpdateSite(UpdateSiteRequest updateSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSiteRequestProtocolMarshaller(protocolFactory).marshall((UpdateSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSiteResult updateSiteResult = (UpdateSiteResult)response.getAwsResponse();
            return updateSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSiteAddressResult updateSiteAddress(UpdateSiteAddressRequest request) {
        request = (UpdateSiteAddressRequest)this.beforeClientExecution(request);
        return this.executeUpdateSiteAddress(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSiteAddressResult executeUpdateSiteAddress(UpdateSiteAddressRequest updateSiteAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSiteAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSiteAddressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSiteAddressRequestProtocolMarshaller(protocolFactory).marshall((UpdateSiteAddressRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSiteAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSiteAddress");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSiteAddressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSiteAddressResult updateSiteAddressResult = (UpdateSiteAddressResult)response.getAwsResponse();
            return updateSiteAddressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSiteRackPhysicalPropertiesResult updateSiteRackPhysicalProperties(UpdateSiteRackPhysicalPropertiesRequest request) {
        request = (UpdateSiteRackPhysicalPropertiesRequest)this.beforeClientExecution(request);
        return this.executeUpdateSiteRackPhysicalProperties(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSiteRackPhysicalPropertiesResult executeUpdateSiteRackPhysicalProperties(UpdateSiteRackPhysicalPropertiesRequest updateSiteRackPhysicalPropertiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSiteRackPhysicalPropertiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSiteRackPhysicalPropertiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSiteRackPhysicalPropertiesRequestProtocolMarshaller(protocolFactory).marshall((UpdateSiteRackPhysicalPropertiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSiteRackPhysicalPropertiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Outposts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSiteRackPhysicalProperties");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSiteRackPhysicalPropertiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSiteRackPhysicalPropertiesResult updateSiteRackPhysicalPropertiesResult = (UpdateSiteRackPhysicalPropertiesResult)response.getAwsResponse();
            return updateSiteRackPhysicalPropertiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

