/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.prometheus.AmazonPrometheus;
import com.amazonaws.services.prometheus.model.DescribeScraperRequest;
import com.amazonaws.services.prometheus.model.DescribeWorkspaceRequest;
import com.amazonaws.services.prometheus.waiters.DescribeScraperFunction;
import com.amazonaws.services.prometheus.waiters.DescribeWorkspaceFunction;
import com.amazonaws.services.prometheus.waiters.ScraperActive;
import com.amazonaws.services.prometheus.waiters.ScraperDeleted;
import com.amazonaws.services.prometheus.waiters.WorkspaceActive;
import com.amazonaws.services.prometheus.waiters.WorkspaceDeleted;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonPrometheusWaiters {
    private final AmazonPrometheus client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonPrometheusWaiters");

    @SdkInternalApi
    public AmazonPrometheusWaiters(AmazonPrometheus client) {
        this.client = client;
    }

    public Waiter<DescribeWorkspaceRequest> workspaceDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeWorkspaceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new WorkspaceDeleted.IsResourceNotFoundExceptionMatcher(), new WorkspaceDeleted.IsDELETINGMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeScraperRequest> scraperDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeScraperFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ScraperDeleted.IsResourceNotFoundExceptionMatcher(), new ScraperDeleted.IsDELETION_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeWorkspaceRequest> workspaceActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeWorkspaceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new WorkspaceActive.IsACTIVEMatcher(), new WorkspaceActive.IsUPDATINGMatcher(), new WorkspaceActive.IsCREATINGMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeScraperRequest> scraperActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeScraperFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ScraperActive.IsACTIVEMatcher(), new ScraperActive.IsCREATION_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

