/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.proton.model.ServiceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListServicesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ServiceSummary> services;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListServicesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ServiceSummary> getServices() {
        return this.services;
    }

    public void setServices(Collection<ServiceSummary> services) {
        if (services == null) {
            this.services = null;
            return;
        }
        this.services = new ArrayList<ServiceSummary>(services);
    }

    public ListServicesResult withServices(ServiceSummary ... services) {
        if (this.services == null) {
            this.setServices(new ArrayList<ServiceSummary>(services.length));
        }
        for (ServiceSummary ele : services) {
            this.services.add(ele);
        }
        return this;
    }

    public ListServicesResult withServices(Collection<ServiceSummary> services) {
        this.setServices(services);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getServices() != null) {
            sb.append("Services: ").append(this.getServices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResult)) {
            return false;
        }
        ListServicesResult other = (ListServicesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getServices() == null ^ this.getServices() == null) {
            return false;
        }
        return other.getServices() == null || other.getServices().equals(this.getServices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getServices() == null ? 0 : this.getServices().hashCode());
        return hashCode;
    }

    public ListServicesResult clone() {
        try {
            return (ListServicesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

