/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model.transform;

import com.amazonaws.services.qbusiness.model.DocumentContent;
import com.amazonaws.services.qbusiness.model.transform.S3JsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class DocumentContentJsonUnmarshaller
implements Unmarshaller<DocumentContent, JsonUnmarshallerContext> {
    private static DocumentContentJsonUnmarshaller instance;

    public DocumentContent unmarshall(JsonUnmarshallerContext context) throws Exception {
        DocumentContent documentContent = new DocumentContent();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("blob", targetDepth)) {
                    context.nextToken();
                    documentContent.setBlob((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("s3", targetDepth)) {
                    context.nextToken();
                    documentContent.setS3(S3JsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return documentContent;
    }

    public static DocumentContentJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentContentJsonUnmarshaller();
        }
        return instance;
    }
}

