/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.s3control.AWSS3ControlAsync;
import com.amazonaws.services.s3control.AWSS3ControlAsyncClientBuilder;
import com.amazonaws.services.s3control.AWSS3ControlClient;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockResult;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockResult;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSS3ControlAsyncClient
extends AWSS3ControlClient
implements AWSS3ControlAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSS3ControlAsyncClientBuilder asyncBuilder() {
        return AWSS3ControlAsyncClientBuilder.standard();
    }

    AWSS3ControlAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeletePublicAccessBlockResult> deletePublicAccessBlockAsync(DeletePublicAccessBlockRequest request) {
        return this.deletePublicAccessBlockAsync(request, null);
    }

    @Override
    public Future<DeletePublicAccessBlockResult> deletePublicAccessBlockAsync(DeletePublicAccessBlockRequest request, final AsyncHandler<DeletePublicAccessBlockRequest, DeletePublicAccessBlockResult> asyncHandler) {
        final DeletePublicAccessBlockRequest finalRequest = (DeletePublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePublicAccessBlockResult>(){

            @Override
            public DeletePublicAccessBlockResult call() throws Exception {
                DeletePublicAccessBlockResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeDeletePublicAccessBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPublicAccessBlockResult> getPublicAccessBlockAsync(GetPublicAccessBlockRequest request) {
        return this.getPublicAccessBlockAsync(request, null);
    }

    @Override
    public Future<GetPublicAccessBlockResult> getPublicAccessBlockAsync(GetPublicAccessBlockRequest request, final AsyncHandler<GetPublicAccessBlockRequest, GetPublicAccessBlockResult> asyncHandler) {
        final GetPublicAccessBlockRequest finalRequest = (GetPublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPublicAccessBlockResult>(){

            @Override
            public GetPublicAccessBlockResult call() throws Exception {
                GetPublicAccessBlockResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executeGetPublicAccessBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPublicAccessBlockResult> putPublicAccessBlockAsync(PutPublicAccessBlockRequest request) {
        return this.putPublicAccessBlockAsync(request, null);
    }

    @Override
    public Future<PutPublicAccessBlockResult> putPublicAccessBlockAsync(PutPublicAccessBlockRequest request, final AsyncHandler<PutPublicAccessBlockRequest, PutPublicAccessBlockResult> asyncHandler) {
        final PutPublicAccessBlockRequest finalRequest = (PutPublicAccessBlockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPublicAccessBlockResult>(){

            @Override
            public PutPublicAccessBlockResult call() throws Exception {
                PutPublicAccessBlockResult result = null;
                try {
                    result = AWSS3ControlAsyncClient.this.executePutPublicAccessBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

