/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.S3AccessControlList;
import com.amazonaws.services.s3control.model.S3Grant;
import com.amazonaws.services.s3control.model.transform.S3GrantStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.S3ObjectOwnerStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class S3AccessControlListStaxUnmarshaller
implements Unmarshaller<S3AccessControlList, StaxUnmarshallerContext> {
    private static S3AccessControlListStaxUnmarshaller instance;

    public S3AccessControlList unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3AccessControlList s3AccessControlList = new S3AccessControlList();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3AccessControlList;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Owner", targetDepth)) {
                    s3AccessControlList.setOwner(S3ObjectOwnerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Grants", targetDepth)) {
                    s3AccessControlList.withGrants(new ArrayList<S3Grant>());
                    continue;
                }
                if (!context.testExpression("Grants/member", targetDepth)) continue;
                s3AccessControlList.withGrants(S3GrantStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3AccessControlList;
    }

    public static S3AccessControlListStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3AccessControlListStaxUnmarshaller();
        }
        return instance;
    }
}

