/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.CreateMultiRegionAccessPointInput;
import com.amazonaws.services.s3control.model.CreateMultiRegionAccessPointRequest;
import com.amazonaws.services.s3control.model.PublicAccessBlockConfiguration;
import com.amazonaws.services.s3control.model.Region;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateMultiRegionAccessPointRequestMarshaller
implements Marshaller<Request<CreateMultiRegionAccessPointRequest>, CreateMultiRegionAccessPointRequest> {
    public Request<CreateMultiRegionAccessPointRequest> marshall(CreateMultiRegionAccessPointRequest createMultiRegionAccessPointRequest) {
        if (createMultiRegionAccessPointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createMultiRegionAccessPointRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (createMultiRegionAccessPointRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)createMultiRegionAccessPointRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/async-requests/mrap/create";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("CreateMultiRegionAccessPointRequest");
            if (createMultiRegionAccessPointRequest != null) {
                xmlWriter.startElement("ClientToken").value(IdempotentUtils.resolveString((String)createMultiRegionAccessPointRequest.getClientToken())).endElement();
                CreateMultiRegionAccessPointInput details = createMultiRegionAccessPointRequest.getDetails();
                if (details != null) {
                    List<Region> createMultiRegionAccessPointInputRegionsList;
                    PublicAccessBlockConfiguration publicAccessBlock;
                    xmlWriter.startElement("Details");
                    if (details.getName() != null) {
                        xmlWriter.startElement("Name").value(details.getName()).endElement();
                    }
                    if ((publicAccessBlock = details.getPublicAccessBlock()) != null) {
                        xmlWriter.startElement("PublicAccessBlock");
                        if (publicAccessBlock.getBlockPublicAcls() != null) {
                            xmlWriter.startElement("BlockPublicAcls").value((Object)publicAccessBlock.getBlockPublicAcls()).endElement();
                        }
                        if (publicAccessBlock.getIgnorePublicAcls() != null) {
                            xmlWriter.startElement("IgnorePublicAcls").value((Object)publicAccessBlock.getIgnorePublicAcls()).endElement();
                        }
                        if (publicAccessBlock.getBlockPublicPolicy() != null) {
                            xmlWriter.startElement("BlockPublicPolicy").value((Object)publicAccessBlock.getBlockPublicPolicy()).endElement();
                        }
                        if (publicAccessBlock.getRestrictPublicBuckets() != null) {
                            xmlWriter.startElement("RestrictPublicBuckets").value((Object)publicAccessBlock.getRestrictPublicBuckets()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((createMultiRegionAccessPointInputRegionsList = details.getRegions()) != null) {
                        xmlWriter.startElement("Regions");
                        for (Region createMultiRegionAccessPointInputRegionsListValue : createMultiRegionAccessPointInputRegionsList) {
                            xmlWriter.startElement("Region");
                            if (createMultiRegionAccessPointInputRegionsListValue.getBucket() != null) {
                                xmlWriter.startElement("Bucket").value(createMultiRegionAccessPointInputRegionsListValue.getBucket()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

