/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.model.DescribeEndpointRequest;
import com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceRequest;
import com.amazonaws.services.sagemaker.model.DescribeTrainingJobRequest;
import com.amazonaws.services.sagemaker.waiters.DescribeEndpointFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeNotebookInstanceFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeTrainingJobFunction;
import com.amazonaws.services.sagemaker.waiters.Endpoint_Created;
import com.amazonaws.services.sagemaker.waiters.Endpoint_Deleted;
import com.amazonaws.services.sagemaker.waiters.Endpoint_Updated;
import com.amazonaws.services.sagemaker.waiters.NotebookInstance_Deleted;
import com.amazonaws.services.sagemaker.waiters.NotebookInstance_Running;
import com.amazonaws.services.sagemaker.waiters.NotebookInstance_Stopped;
import com.amazonaws.services.sagemaker.waiters.TrainingJob_Created;
import com.amazonaws.services.sagemaker.waiters.TrainingJob_Deleted;
import com.amazonaws.services.sagemaker.waiters.TrainingJob_Stopped;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonSageMakerWaiters {
    private final AmazonSageMaker client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonSageMakerWaiters(AmazonSageMaker client) {
        this.client = client;
    }

    public Waiter<DescribeTrainingJobRequest> trainingJob_Stopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTrainingJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TrainingJob_Stopped.IsCompletedMatcher(), new TrainingJob_Stopped.IsStoppingMatcher(), new TrainingJob_Stopped.IsStoppedMatcher(), new TrainingJob_Stopped.IsThrottlingExceptionMatcher(), new TrainingJob_Stopped.IsValidationExceptionMatcher(), new TrainingJob_Stopped.IsFailedMatcher(), new TrainingJob_Stopped.IsDeletingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTrainingJobRequest> trainingJob_Deleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTrainingJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TrainingJob_Deleted.IsValidationExceptionMatcher(), new TrainingJob_Deleted.IsDeletingMatcher(), new TrainingJob_Deleted.IsThrottlingExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointRequest> endpoint_Updated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEndpointFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new Endpoint_Updated.Is200Matcher(), new Endpoint_Updated.IsUpdatingMatcher(), new Endpoint_Updated.IsRollingBackMatcher(), new Endpoint_Updated.IsFailedMatcher(), new Endpoint_Updated.IsThrottlingExceptionMatcher(), new Endpoint_Updated.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstance_Running() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NotebookInstance_Running.IsInServiceMatcher(), new NotebookInstance_Running.IsThrottlingExceptionMatcher(), new NotebookInstance_Running.IsFailedMatcher(), new NotebookInstance_Running.IsStoppedMatcher(), new NotebookInstance_Running.IsStoppingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstance_Deleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NotebookInstance_Deleted.IsValidationExceptionMatcher(), new NotebookInstance_Deleted.IsDeletingMatcher(), new NotebookInstance_Deleted.IsThrottlingExceptionMatcher(), new NotebookInstance_Deleted.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointRequest> endpoint_Created() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEndpointFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new Endpoint_Created.IsInServiceMatcher(), new Endpoint_Created.IsCreatingMatcher(), new Endpoint_Created.IsFailedMatcher(), new Endpoint_Created.IsThrottlingExceptionMatcher(), new Endpoint_Created.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstance_Stopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NotebookInstance_Stopped.IsStoppedMatcher(), new NotebookInstance_Stopped.IsStoppingMatcher(), new NotebookInstance_Stopped.IsThrottlingExceptionMatcher(), new NotebookInstance_Stopped.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointRequest> endpoint_Deleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEndpointFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new Endpoint_Deleted.IsValidationExceptionMatcher(), new Endpoint_Deleted.IsDeletingMatcher(), new Endpoint_Deleted.IsFailedMatcher(), new Endpoint_Deleted.IsThrottlingExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTrainingJobRequest> trainingJob_Created() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTrainingJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TrainingJob_Created.IsCreatedMatcher(), new TrainingJob_Created.IsCompletedMatcher(), new TrainingJob_Created.IsInProgressMatcher(), new TrainingJob_Created.IsFailedMatcher(), new TrainingJob_Created.IsStoppingMatcher(), new TrainingJob_Created.IsStoppedMatcher(), new TrainingJob_Created.IsDeletingMatcher(), new TrainingJob_Created.IsValidationExceptionMatcher(), new TrainingJob_Created.IsThrottlingExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

