/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sagemaker.AmazonSageMakerAsync;
import com.amazonaws.services.sagemaker.AmazonSageMakerAsyncClientBuilder;
import com.amazonaws.services.sagemaker.AmazonSageMakerClient;
import com.amazonaws.services.sagemaker.model.AddTagsRequest;
import com.amazonaws.services.sagemaker.model.AddTagsResult;
import com.amazonaws.services.sagemaker.model.CreateEndpointConfigRequest;
import com.amazonaws.services.sagemaker.model.CreateEndpointConfigResult;
import com.amazonaws.services.sagemaker.model.CreateEndpointRequest;
import com.amazonaws.services.sagemaker.model.CreateEndpointResult;
import com.amazonaws.services.sagemaker.model.CreateModelRequest;
import com.amazonaws.services.sagemaker.model.CreateModelResult;
import com.amazonaws.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest;
import com.amazonaws.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResult;
import com.amazonaws.services.sagemaker.model.CreateNotebookInstanceRequest;
import com.amazonaws.services.sagemaker.model.CreateNotebookInstanceResult;
import com.amazonaws.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest;
import com.amazonaws.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResult;
import com.amazonaws.services.sagemaker.model.CreateTrainingJobRequest;
import com.amazonaws.services.sagemaker.model.CreateTrainingJobResult;
import com.amazonaws.services.sagemaker.model.DeleteEndpointConfigRequest;
import com.amazonaws.services.sagemaker.model.DeleteEndpointConfigResult;
import com.amazonaws.services.sagemaker.model.DeleteEndpointRequest;
import com.amazonaws.services.sagemaker.model.DeleteEndpointResult;
import com.amazonaws.services.sagemaker.model.DeleteModelRequest;
import com.amazonaws.services.sagemaker.model.DeleteModelResult;
import com.amazonaws.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest;
import com.amazonaws.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigResult;
import com.amazonaws.services.sagemaker.model.DeleteNotebookInstanceRequest;
import com.amazonaws.services.sagemaker.model.DeleteNotebookInstanceResult;
import com.amazonaws.services.sagemaker.model.DeleteTagsRequest;
import com.amazonaws.services.sagemaker.model.DeleteTagsResult;
import com.amazonaws.services.sagemaker.model.DescribeEndpointConfigRequest;
import com.amazonaws.services.sagemaker.model.DescribeEndpointConfigResult;
import com.amazonaws.services.sagemaker.model.DescribeEndpointRequest;
import com.amazonaws.services.sagemaker.model.DescribeEndpointResult;
import com.amazonaws.services.sagemaker.model.DescribeModelRequest;
import com.amazonaws.services.sagemaker.model.DescribeModelResult;
import com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest;
import com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResult;
import com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceRequest;
import com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceResult;
import com.amazonaws.services.sagemaker.model.DescribeTrainingJobRequest;
import com.amazonaws.services.sagemaker.model.DescribeTrainingJobResult;
import com.amazonaws.services.sagemaker.model.ListEndpointConfigsRequest;
import com.amazonaws.services.sagemaker.model.ListEndpointConfigsResult;
import com.amazonaws.services.sagemaker.model.ListEndpointsRequest;
import com.amazonaws.services.sagemaker.model.ListEndpointsResult;
import com.amazonaws.services.sagemaker.model.ListModelsRequest;
import com.amazonaws.services.sagemaker.model.ListModelsResult;
import com.amazonaws.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest;
import com.amazonaws.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResult;
import com.amazonaws.services.sagemaker.model.ListNotebookInstancesRequest;
import com.amazonaws.services.sagemaker.model.ListNotebookInstancesResult;
import com.amazonaws.services.sagemaker.model.ListTagsRequest;
import com.amazonaws.services.sagemaker.model.ListTagsResult;
import com.amazonaws.services.sagemaker.model.ListTrainingJobsRequest;
import com.amazonaws.services.sagemaker.model.ListTrainingJobsResult;
import com.amazonaws.services.sagemaker.model.StartNotebookInstanceRequest;
import com.amazonaws.services.sagemaker.model.StartNotebookInstanceResult;
import com.amazonaws.services.sagemaker.model.StopNotebookInstanceRequest;
import com.amazonaws.services.sagemaker.model.StopNotebookInstanceResult;
import com.amazonaws.services.sagemaker.model.StopTrainingJobRequest;
import com.amazonaws.services.sagemaker.model.StopTrainingJobResult;
import com.amazonaws.services.sagemaker.model.UpdateEndpointRequest;
import com.amazonaws.services.sagemaker.model.UpdateEndpointResult;
import com.amazonaws.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest;
import com.amazonaws.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResult;
import com.amazonaws.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest;
import com.amazonaws.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResult;
import com.amazonaws.services.sagemaker.model.UpdateNotebookInstanceRequest;
import com.amazonaws.services.sagemaker.model.UpdateNotebookInstanceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSageMakerAsyncClient
extends AmazonSageMakerClient
implements AmazonSageMakerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonSageMakerAsyncClientBuilder asyncBuilder() {
        return AmazonSageMakerAsyncClientBuilder.standard();
    }

    AmazonSageMakerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request) {
        return this.addTagsAsync(request, null);
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) {
        final AddTagsRequest finalRequest = (AddTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeAddTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEndpointResult> createEndpointAsync(CreateEndpointRequest request) {
        return this.createEndpointAsync(request, null);
    }

    @Override
    public Future<CreateEndpointResult> createEndpointAsync(CreateEndpointRequest request, final AsyncHandler<CreateEndpointRequest, CreateEndpointResult> asyncHandler) {
        final CreateEndpointRequest finalRequest = (CreateEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEndpointResult>(){

            @Override
            public CreateEndpointResult call() throws Exception {
                CreateEndpointResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeCreateEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEndpointConfigResult> createEndpointConfigAsync(CreateEndpointConfigRequest request) {
        return this.createEndpointConfigAsync(request, null);
    }

    @Override
    public Future<CreateEndpointConfigResult> createEndpointConfigAsync(CreateEndpointConfigRequest request, final AsyncHandler<CreateEndpointConfigRequest, CreateEndpointConfigResult> asyncHandler) {
        final CreateEndpointConfigRequest finalRequest = (CreateEndpointConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEndpointConfigResult>(){

            @Override
            public CreateEndpointConfigResult call() throws Exception {
                CreateEndpointConfigResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeCreateEndpointConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateModelResult> createModelAsync(CreateModelRequest request) {
        return this.createModelAsync(request, null);
    }

    @Override
    public Future<CreateModelResult> createModelAsync(CreateModelRequest request, final AsyncHandler<CreateModelRequest, CreateModelResult> asyncHandler) {
        final CreateModelRequest finalRequest = (CreateModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateModelResult>(){

            @Override
            public CreateModelResult call() throws Exception {
                CreateModelResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeCreateModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNotebookInstanceResult> createNotebookInstanceAsync(CreateNotebookInstanceRequest request) {
        return this.createNotebookInstanceAsync(request, null);
    }

    @Override
    public Future<CreateNotebookInstanceResult> createNotebookInstanceAsync(CreateNotebookInstanceRequest request, final AsyncHandler<CreateNotebookInstanceRequest, CreateNotebookInstanceResult> asyncHandler) {
        final CreateNotebookInstanceRequest finalRequest = (CreateNotebookInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNotebookInstanceResult>(){

            @Override
            public CreateNotebookInstanceResult call() throws Exception {
                CreateNotebookInstanceResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeCreateNotebookInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNotebookInstanceLifecycleConfigResult> createNotebookInstanceLifecycleConfigAsync(CreateNotebookInstanceLifecycleConfigRequest request) {
        return this.createNotebookInstanceLifecycleConfigAsync(request, null);
    }

    @Override
    public Future<CreateNotebookInstanceLifecycleConfigResult> createNotebookInstanceLifecycleConfigAsync(CreateNotebookInstanceLifecycleConfigRequest request, final AsyncHandler<CreateNotebookInstanceLifecycleConfigRequest, CreateNotebookInstanceLifecycleConfigResult> asyncHandler) {
        final CreateNotebookInstanceLifecycleConfigRequest finalRequest = (CreateNotebookInstanceLifecycleConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNotebookInstanceLifecycleConfigResult>(){

            @Override
            public CreateNotebookInstanceLifecycleConfigResult call() throws Exception {
                CreateNotebookInstanceLifecycleConfigResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeCreateNotebookInstanceLifecycleConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePresignedNotebookInstanceUrlResult> createPresignedNotebookInstanceUrlAsync(CreatePresignedNotebookInstanceUrlRequest request) {
        return this.createPresignedNotebookInstanceUrlAsync(request, null);
    }

    @Override
    public Future<CreatePresignedNotebookInstanceUrlResult> createPresignedNotebookInstanceUrlAsync(CreatePresignedNotebookInstanceUrlRequest request, final AsyncHandler<CreatePresignedNotebookInstanceUrlRequest, CreatePresignedNotebookInstanceUrlResult> asyncHandler) {
        final CreatePresignedNotebookInstanceUrlRequest finalRequest = (CreatePresignedNotebookInstanceUrlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePresignedNotebookInstanceUrlResult>(){

            @Override
            public CreatePresignedNotebookInstanceUrlResult call() throws Exception {
                CreatePresignedNotebookInstanceUrlResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeCreatePresignedNotebookInstanceUrl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrainingJobResult> createTrainingJobAsync(CreateTrainingJobRequest request) {
        return this.createTrainingJobAsync(request, null);
    }

    @Override
    public Future<CreateTrainingJobResult> createTrainingJobAsync(CreateTrainingJobRequest request, final AsyncHandler<CreateTrainingJobRequest, CreateTrainingJobResult> asyncHandler) {
        final CreateTrainingJobRequest finalRequest = (CreateTrainingJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTrainingJobResult>(){

            @Override
            public CreateTrainingJobResult call() throws Exception {
                CreateTrainingJobResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeCreateTrainingJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEndpointResult> deleteEndpointAsync(DeleteEndpointRequest request) {
        return this.deleteEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteEndpointResult> deleteEndpointAsync(DeleteEndpointRequest request, final AsyncHandler<DeleteEndpointRequest, DeleteEndpointResult> asyncHandler) {
        final DeleteEndpointRequest finalRequest = (DeleteEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEndpointResult>(){

            @Override
            public DeleteEndpointResult call() throws Exception {
                DeleteEndpointResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDeleteEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEndpointConfigResult> deleteEndpointConfigAsync(DeleteEndpointConfigRequest request) {
        return this.deleteEndpointConfigAsync(request, null);
    }

    @Override
    public Future<DeleteEndpointConfigResult> deleteEndpointConfigAsync(DeleteEndpointConfigRequest request, final AsyncHandler<DeleteEndpointConfigRequest, DeleteEndpointConfigResult> asyncHandler) {
        final DeleteEndpointConfigRequest finalRequest = (DeleteEndpointConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEndpointConfigResult>(){

            @Override
            public DeleteEndpointConfigResult call() throws Exception {
                DeleteEndpointConfigResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDeleteEndpointConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteModelResult> deleteModelAsync(DeleteModelRequest request) {
        return this.deleteModelAsync(request, null);
    }

    @Override
    public Future<DeleteModelResult> deleteModelAsync(DeleteModelRequest request, final AsyncHandler<DeleteModelRequest, DeleteModelResult> asyncHandler) {
        final DeleteModelRequest finalRequest = (DeleteModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteModelResult>(){

            @Override
            public DeleteModelResult call() throws Exception {
                DeleteModelResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDeleteModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNotebookInstanceResult> deleteNotebookInstanceAsync(DeleteNotebookInstanceRequest request) {
        return this.deleteNotebookInstanceAsync(request, null);
    }

    @Override
    public Future<DeleteNotebookInstanceResult> deleteNotebookInstanceAsync(DeleteNotebookInstanceRequest request, final AsyncHandler<DeleteNotebookInstanceRequest, DeleteNotebookInstanceResult> asyncHandler) {
        final DeleteNotebookInstanceRequest finalRequest = (DeleteNotebookInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNotebookInstanceResult>(){

            @Override
            public DeleteNotebookInstanceResult call() throws Exception {
                DeleteNotebookInstanceResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDeleteNotebookInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNotebookInstanceLifecycleConfigResult> deleteNotebookInstanceLifecycleConfigAsync(DeleteNotebookInstanceLifecycleConfigRequest request) {
        return this.deleteNotebookInstanceLifecycleConfigAsync(request, null);
    }

    @Override
    public Future<DeleteNotebookInstanceLifecycleConfigResult> deleteNotebookInstanceLifecycleConfigAsync(DeleteNotebookInstanceLifecycleConfigRequest request, final AsyncHandler<DeleteNotebookInstanceLifecycleConfigRequest, DeleteNotebookInstanceLifecycleConfigResult> asyncHandler) {
        final DeleteNotebookInstanceLifecycleConfigRequest finalRequest = (DeleteNotebookInstanceLifecycleConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNotebookInstanceLifecycleConfigResult>(){

            @Override
            public DeleteNotebookInstanceLifecycleConfigResult call() throws Exception {
                DeleteNotebookInstanceLifecycleConfigResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDeleteNotebookInstanceLifecycleConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        final DeleteTagsRequest finalRequest = (DeleteTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDeleteTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEndpointResult> describeEndpointAsync(DescribeEndpointRequest request) {
        return this.describeEndpointAsync(request, null);
    }

    @Override
    public Future<DescribeEndpointResult> describeEndpointAsync(DescribeEndpointRequest request, final AsyncHandler<DescribeEndpointRequest, DescribeEndpointResult> asyncHandler) {
        final DescribeEndpointRequest finalRequest = (DescribeEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEndpointResult>(){

            @Override
            public DescribeEndpointResult call() throws Exception {
                DescribeEndpointResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDescribeEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEndpointConfigResult> describeEndpointConfigAsync(DescribeEndpointConfigRequest request) {
        return this.describeEndpointConfigAsync(request, null);
    }

    @Override
    public Future<DescribeEndpointConfigResult> describeEndpointConfigAsync(DescribeEndpointConfigRequest request, final AsyncHandler<DescribeEndpointConfigRequest, DescribeEndpointConfigResult> asyncHandler) {
        final DescribeEndpointConfigRequest finalRequest = (DescribeEndpointConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEndpointConfigResult>(){

            @Override
            public DescribeEndpointConfigResult call() throws Exception {
                DescribeEndpointConfigResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDescribeEndpointConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeModelResult> describeModelAsync(DescribeModelRequest request) {
        return this.describeModelAsync(request, null);
    }

    @Override
    public Future<DescribeModelResult> describeModelAsync(DescribeModelRequest request, final AsyncHandler<DescribeModelRequest, DescribeModelResult> asyncHandler) {
        final DescribeModelRequest finalRequest = (DescribeModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeModelResult>(){

            @Override
            public DescribeModelResult call() throws Exception {
                DescribeModelResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDescribeModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNotebookInstanceResult> describeNotebookInstanceAsync(DescribeNotebookInstanceRequest request) {
        return this.describeNotebookInstanceAsync(request, null);
    }

    @Override
    public Future<DescribeNotebookInstanceResult> describeNotebookInstanceAsync(DescribeNotebookInstanceRequest request, final AsyncHandler<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResult> asyncHandler) {
        final DescribeNotebookInstanceRequest finalRequest = (DescribeNotebookInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeNotebookInstanceResult>(){

            @Override
            public DescribeNotebookInstanceResult call() throws Exception {
                DescribeNotebookInstanceResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDescribeNotebookInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNotebookInstanceLifecycleConfigResult> describeNotebookInstanceLifecycleConfigAsync(DescribeNotebookInstanceLifecycleConfigRequest request) {
        return this.describeNotebookInstanceLifecycleConfigAsync(request, null);
    }

    @Override
    public Future<DescribeNotebookInstanceLifecycleConfigResult> describeNotebookInstanceLifecycleConfigAsync(DescribeNotebookInstanceLifecycleConfigRequest request, final AsyncHandler<DescribeNotebookInstanceLifecycleConfigRequest, DescribeNotebookInstanceLifecycleConfigResult> asyncHandler) {
        final DescribeNotebookInstanceLifecycleConfigRequest finalRequest = (DescribeNotebookInstanceLifecycleConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeNotebookInstanceLifecycleConfigResult>(){

            @Override
            public DescribeNotebookInstanceLifecycleConfigResult call() throws Exception {
                DescribeNotebookInstanceLifecycleConfigResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDescribeNotebookInstanceLifecycleConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrainingJobResult> describeTrainingJobAsync(DescribeTrainingJobRequest request) {
        return this.describeTrainingJobAsync(request, null);
    }

    @Override
    public Future<DescribeTrainingJobResult> describeTrainingJobAsync(DescribeTrainingJobRequest request, final AsyncHandler<DescribeTrainingJobRequest, DescribeTrainingJobResult> asyncHandler) {
        final DescribeTrainingJobRequest finalRequest = (DescribeTrainingJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTrainingJobResult>(){

            @Override
            public DescribeTrainingJobResult call() throws Exception {
                DescribeTrainingJobResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeDescribeTrainingJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEndpointConfigsResult> listEndpointConfigsAsync(ListEndpointConfigsRequest request) {
        return this.listEndpointConfigsAsync(request, null);
    }

    @Override
    public Future<ListEndpointConfigsResult> listEndpointConfigsAsync(ListEndpointConfigsRequest request, final AsyncHandler<ListEndpointConfigsRequest, ListEndpointConfigsResult> asyncHandler) {
        final ListEndpointConfigsRequest finalRequest = (ListEndpointConfigsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEndpointConfigsResult>(){

            @Override
            public ListEndpointConfigsResult call() throws Exception {
                ListEndpointConfigsResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeListEndpointConfigs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEndpointsResult> listEndpointsAsync(ListEndpointsRequest request) {
        return this.listEndpointsAsync(request, null);
    }

    @Override
    public Future<ListEndpointsResult> listEndpointsAsync(ListEndpointsRequest request, final AsyncHandler<ListEndpointsRequest, ListEndpointsResult> asyncHandler) {
        final ListEndpointsRequest finalRequest = (ListEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEndpointsResult>(){

            @Override
            public ListEndpointsResult call() throws Exception {
                ListEndpointsResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeListEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListModelsResult> listModelsAsync(ListModelsRequest request) {
        return this.listModelsAsync(request, null);
    }

    @Override
    public Future<ListModelsResult> listModelsAsync(ListModelsRequest request, final AsyncHandler<ListModelsRequest, ListModelsResult> asyncHandler) {
        final ListModelsRequest finalRequest = (ListModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListModelsResult>(){

            @Override
            public ListModelsResult call() throws Exception {
                ListModelsResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeListModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNotebookInstanceLifecycleConfigsResult> listNotebookInstanceLifecycleConfigsAsync(ListNotebookInstanceLifecycleConfigsRequest request) {
        return this.listNotebookInstanceLifecycleConfigsAsync(request, null);
    }

    @Override
    public Future<ListNotebookInstanceLifecycleConfigsResult> listNotebookInstanceLifecycleConfigsAsync(ListNotebookInstanceLifecycleConfigsRequest request, final AsyncHandler<ListNotebookInstanceLifecycleConfigsRequest, ListNotebookInstanceLifecycleConfigsResult> asyncHandler) {
        final ListNotebookInstanceLifecycleConfigsRequest finalRequest = (ListNotebookInstanceLifecycleConfigsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNotebookInstanceLifecycleConfigsResult>(){

            @Override
            public ListNotebookInstanceLifecycleConfigsResult call() throws Exception {
                ListNotebookInstanceLifecycleConfigsResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeListNotebookInstanceLifecycleConfigs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNotebookInstancesResult> listNotebookInstancesAsync(ListNotebookInstancesRequest request) {
        return this.listNotebookInstancesAsync(request, null);
    }

    @Override
    public Future<ListNotebookInstancesResult> listNotebookInstancesAsync(ListNotebookInstancesRequest request, final AsyncHandler<ListNotebookInstancesRequest, ListNotebookInstancesResult> asyncHandler) {
        final ListNotebookInstancesRequest finalRequest = (ListNotebookInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNotebookInstancesResult>(){

            @Override
            public ListNotebookInstancesResult call() throws Exception {
                ListNotebookInstancesResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeListNotebookInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request) {
        return this.listTagsAsync(request, null);
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request, final AsyncHandler<ListTagsRequest, ListTagsResult> asyncHandler) {
        final ListTagsRequest finalRequest = (ListTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsResult>(){

            @Override
            public ListTagsResult call() throws Exception {
                ListTagsResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeListTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTrainingJobsResult> listTrainingJobsAsync(ListTrainingJobsRequest request) {
        return this.listTrainingJobsAsync(request, null);
    }

    @Override
    public Future<ListTrainingJobsResult> listTrainingJobsAsync(ListTrainingJobsRequest request, final AsyncHandler<ListTrainingJobsRequest, ListTrainingJobsResult> asyncHandler) {
        final ListTrainingJobsRequest finalRequest = (ListTrainingJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTrainingJobsResult>(){

            @Override
            public ListTrainingJobsResult call() throws Exception {
                ListTrainingJobsResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeListTrainingJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartNotebookInstanceResult> startNotebookInstanceAsync(StartNotebookInstanceRequest request) {
        return this.startNotebookInstanceAsync(request, null);
    }

    @Override
    public Future<StartNotebookInstanceResult> startNotebookInstanceAsync(StartNotebookInstanceRequest request, final AsyncHandler<StartNotebookInstanceRequest, StartNotebookInstanceResult> asyncHandler) {
        final StartNotebookInstanceRequest finalRequest = (StartNotebookInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartNotebookInstanceResult>(){

            @Override
            public StartNotebookInstanceResult call() throws Exception {
                StartNotebookInstanceResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeStartNotebookInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopNotebookInstanceResult> stopNotebookInstanceAsync(StopNotebookInstanceRequest request) {
        return this.stopNotebookInstanceAsync(request, null);
    }

    @Override
    public Future<StopNotebookInstanceResult> stopNotebookInstanceAsync(StopNotebookInstanceRequest request, final AsyncHandler<StopNotebookInstanceRequest, StopNotebookInstanceResult> asyncHandler) {
        final StopNotebookInstanceRequest finalRequest = (StopNotebookInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopNotebookInstanceResult>(){

            @Override
            public StopNotebookInstanceResult call() throws Exception {
                StopNotebookInstanceResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeStopNotebookInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopTrainingJobResult> stopTrainingJobAsync(StopTrainingJobRequest request) {
        return this.stopTrainingJobAsync(request, null);
    }

    @Override
    public Future<StopTrainingJobResult> stopTrainingJobAsync(StopTrainingJobRequest request, final AsyncHandler<StopTrainingJobRequest, StopTrainingJobResult> asyncHandler) {
        final StopTrainingJobRequest finalRequest = (StopTrainingJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopTrainingJobResult>(){

            @Override
            public StopTrainingJobResult call() throws Exception {
                StopTrainingJobResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeStopTrainingJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEndpointResult> updateEndpointAsync(UpdateEndpointRequest request) {
        return this.updateEndpointAsync(request, null);
    }

    @Override
    public Future<UpdateEndpointResult> updateEndpointAsync(UpdateEndpointRequest request, final AsyncHandler<UpdateEndpointRequest, UpdateEndpointResult> asyncHandler) {
        final UpdateEndpointRequest finalRequest = (UpdateEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEndpointResult>(){

            @Override
            public UpdateEndpointResult call() throws Exception {
                UpdateEndpointResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeUpdateEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEndpointWeightsAndCapacitiesResult> updateEndpointWeightsAndCapacitiesAsync(UpdateEndpointWeightsAndCapacitiesRequest request) {
        return this.updateEndpointWeightsAndCapacitiesAsync(request, null);
    }

    @Override
    public Future<UpdateEndpointWeightsAndCapacitiesResult> updateEndpointWeightsAndCapacitiesAsync(UpdateEndpointWeightsAndCapacitiesRequest request, final AsyncHandler<UpdateEndpointWeightsAndCapacitiesRequest, UpdateEndpointWeightsAndCapacitiesResult> asyncHandler) {
        final UpdateEndpointWeightsAndCapacitiesRequest finalRequest = (UpdateEndpointWeightsAndCapacitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEndpointWeightsAndCapacitiesResult>(){

            @Override
            public UpdateEndpointWeightsAndCapacitiesResult call() throws Exception {
                UpdateEndpointWeightsAndCapacitiesResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeUpdateEndpointWeightsAndCapacities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNotebookInstanceResult> updateNotebookInstanceAsync(UpdateNotebookInstanceRequest request) {
        return this.updateNotebookInstanceAsync(request, null);
    }

    @Override
    public Future<UpdateNotebookInstanceResult> updateNotebookInstanceAsync(UpdateNotebookInstanceRequest request, final AsyncHandler<UpdateNotebookInstanceRequest, UpdateNotebookInstanceResult> asyncHandler) {
        final UpdateNotebookInstanceRequest finalRequest = (UpdateNotebookInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNotebookInstanceResult>(){

            @Override
            public UpdateNotebookInstanceResult call() throws Exception {
                UpdateNotebookInstanceResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeUpdateNotebookInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNotebookInstanceLifecycleConfigResult> updateNotebookInstanceLifecycleConfigAsync(UpdateNotebookInstanceLifecycleConfigRequest request) {
        return this.updateNotebookInstanceLifecycleConfigAsync(request, null);
    }

    @Override
    public Future<UpdateNotebookInstanceLifecycleConfigResult> updateNotebookInstanceLifecycleConfigAsync(UpdateNotebookInstanceLifecycleConfigRequest request, final AsyncHandler<UpdateNotebookInstanceLifecycleConfigRequest, UpdateNotebookInstanceLifecycleConfigResult> asyncHandler) {
        final UpdateNotebookInstanceLifecycleConfigRequest finalRequest = (UpdateNotebookInstanceLifecycleConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNotebookInstanceLifecycleConfigResult>(){

            @Override
            public UpdateNotebookInstanceLifecycleConfigResult call() throws Exception {
                UpdateNotebookInstanceLifecycleConfigResult result = null;
                try {
                    result = AmazonSageMakerAsyncClient.this.executeUpdateNotebookInstanceLifecycleConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

