/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.AutoMLChannel;
import com.amazonaws.services.sagemaker.model.AutoMLJobConfig;
import com.amazonaws.services.sagemaker.model.AutoMLJobObjective;
import com.amazonaws.services.sagemaker.model.AutoMLOutputDataConfig;
import com.amazonaws.services.sagemaker.model.ProblemType;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAutoMLJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String autoMLJobName;
    private List<AutoMLChannel> inputDataConfig;
    private AutoMLOutputDataConfig outputDataConfig;
    private String problemType;
    private AutoMLJobObjective autoMLJobObjective;
    private AutoMLJobConfig autoMLJobConfig;
    private String roleArn;
    private Boolean generateCandidateDefinitionsOnly;
    private List<Tag> tags;

    public void setAutoMLJobName(String autoMLJobName) {
        this.autoMLJobName = autoMLJobName;
    }

    public String getAutoMLJobName() {
        return this.autoMLJobName;
    }

    public CreateAutoMLJobRequest withAutoMLJobName(String autoMLJobName) {
        this.setAutoMLJobName(autoMLJobName);
        return this;
    }

    public List<AutoMLChannel> getInputDataConfig() {
        return this.inputDataConfig;
    }

    public void setInputDataConfig(Collection<AutoMLChannel> inputDataConfig) {
        if (inputDataConfig == null) {
            this.inputDataConfig = null;
            return;
        }
        this.inputDataConfig = new ArrayList<AutoMLChannel>(inputDataConfig);
    }

    public CreateAutoMLJobRequest withInputDataConfig(AutoMLChannel ... inputDataConfig) {
        if (this.inputDataConfig == null) {
            this.setInputDataConfig(new ArrayList<AutoMLChannel>(inputDataConfig.length));
        }
        for (AutoMLChannel ele : inputDataConfig) {
            this.inputDataConfig.add(ele);
        }
        return this;
    }

    public CreateAutoMLJobRequest withInputDataConfig(Collection<AutoMLChannel> inputDataConfig) {
        this.setInputDataConfig(inputDataConfig);
        return this;
    }

    public void setOutputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
        this.outputDataConfig = outputDataConfig;
    }

    public AutoMLOutputDataConfig getOutputDataConfig() {
        return this.outputDataConfig;
    }

    public CreateAutoMLJobRequest withOutputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
        this.setOutputDataConfig(outputDataConfig);
        return this;
    }

    public void setProblemType(String problemType) {
        this.problemType = problemType;
    }

    public String getProblemType() {
        return this.problemType;
    }

    public CreateAutoMLJobRequest withProblemType(String problemType) {
        this.setProblemType(problemType);
        return this;
    }

    public CreateAutoMLJobRequest withProblemType(ProblemType problemType) {
        this.problemType = problemType.toString();
        return this;
    }

    public void setAutoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
        this.autoMLJobObjective = autoMLJobObjective;
    }

    public AutoMLJobObjective getAutoMLJobObjective() {
        return this.autoMLJobObjective;
    }

    public CreateAutoMLJobRequest withAutoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
        this.setAutoMLJobObjective(autoMLJobObjective);
        return this;
    }

    public void setAutoMLJobConfig(AutoMLJobConfig autoMLJobConfig) {
        this.autoMLJobConfig = autoMLJobConfig;
    }

    public AutoMLJobConfig getAutoMLJobConfig() {
        return this.autoMLJobConfig;
    }

    public CreateAutoMLJobRequest withAutoMLJobConfig(AutoMLJobConfig autoMLJobConfig) {
        this.setAutoMLJobConfig(autoMLJobConfig);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateAutoMLJobRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setGenerateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
        this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
    }

    public Boolean getGenerateCandidateDefinitionsOnly() {
        return this.generateCandidateDefinitionsOnly;
    }

    public CreateAutoMLJobRequest withGenerateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
        this.setGenerateCandidateDefinitionsOnly(generateCandidateDefinitionsOnly);
        return this;
    }

    public Boolean isGenerateCandidateDefinitionsOnly() {
        return this.generateCandidateDefinitionsOnly;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateAutoMLJobRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAutoMLJobRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoMLJobName() != null) {
            sb.append("AutoMLJobName: ").append(this.getAutoMLJobName()).append(",");
        }
        if (this.getInputDataConfig() != null) {
            sb.append("InputDataConfig: ").append(this.getInputDataConfig()).append(",");
        }
        if (this.getOutputDataConfig() != null) {
            sb.append("OutputDataConfig: ").append(this.getOutputDataConfig()).append(",");
        }
        if (this.getProblemType() != null) {
            sb.append("ProblemType: ").append(this.getProblemType()).append(",");
        }
        if (this.getAutoMLJobObjective() != null) {
            sb.append("AutoMLJobObjective: ").append(this.getAutoMLJobObjective()).append(",");
        }
        if (this.getAutoMLJobConfig() != null) {
            sb.append("AutoMLJobConfig: ").append(this.getAutoMLJobConfig()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getGenerateCandidateDefinitionsOnly() != null) {
            sb.append("GenerateCandidateDefinitionsOnly: ").append(this.getGenerateCandidateDefinitionsOnly()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoMLJobRequest)) {
            return false;
        }
        CreateAutoMLJobRequest other = (CreateAutoMLJobRequest)obj;
        if (other.getAutoMLJobName() == null ^ this.getAutoMLJobName() == null) {
            return false;
        }
        if (other.getAutoMLJobName() != null && !other.getAutoMLJobName().equals(this.getAutoMLJobName())) {
            return false;
        }
        if (other.getInputDataConfig() == null ^ this.getInputDataConfig() == null) {
            return false;
        }
        if (other.getInputDataConfig() != null && !other.getInputDataConfig().equals(this.getInputDataConfig())) {
            return false;
        }
        if (other.getOutputDataConfig() == null ^ this.getOutputDataConfig() == null) {
            return false;
        }
        if (other.getOutputDataConfig() != null && !other.getOutputDataConfig().equals(this.getOutputDataConfig())) {
            return false;
        }
        if (other.getProblemType() == null ^ this.getProblemType() == null) {
            return false;
        }
        if (other.getProblemType() != null && !other.getProblemType().equals(this.getProblemType())) {
            return false;
        }
        if (other.getAutoMLJobObjective() == null ^ this.getAutoMLJobObjective() == null) {
            return false;
        }
        if (other.getAutoMLJobObjective() != null && !other.getAutoMLJobObjective().equals(this.getAutoMLJobObjective())) {
            return false;
        }
        if (other.getAutoMLJobConfig() == null ^ this.getAutoMLJobConfig() == null) {
            return false;
        }
        if (other.getAutoMLJobConfig() != null && !other.getAutoMLJobConfig().equals(this.getAutoMLJobConfig())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getGenerateCandidateDefinitionsOnly() == null ^ this.getGenerateCandidateDefinitionsOnly() == null) {
            return false;
        }
        if (other.getGenerateCandidateDefinitionsOnly() != null && !other.getGenerateCandidateDefinitionsOnly().equals(this.getGenerateCandidateDefinitionsOnly())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoMLJobName() == null ? 0 : this.getAutoMLJobName().hashCode());
        hashCode = 31 * hashCode + (this.getInputDataConfig() == null ? 0 : this.getInputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDataConfig() == null ? 0 : this.getOutputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getProblemType() == null ? 0 : this.getProblemType().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMLJobObjective() == null ? 0 : this.getAutoMLJobObjective().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMLJobConfig() == null ? 0 : this.getAutoMLJobConfig().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getGenerateCandidateDefinitionsOnly() == null ? 0 : this.getGenerateCandidateDefinitionsOnly().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateAutoMLJobRequest clone() {
        return (CreateAutoMLJobRequest)super.clone();
    }
}

