/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.AsyncInferenceConfig;
import com.amazonaws.services.sagemaker.model.DataCaptureConfig;
import com.amazonaws.services.sagemaker.model.ExplainerConfig;
import com.amazonaws.services.sagemaker.model.ProductionVariant;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateEndpointConfigRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String endpointConfigName;
    private List<ProductionVariant> productionVariants;
    private DataCaptureConfig dataCaptureConfig;
    private List<Tag> tags;
    private String kmsKeyId;
    private AsyncInferenceConfig asyncInferenceConfig;
    private ExplainerConfig explainerConfig;

    public void setEndpointConfigName(String endpointConfigName) {
        this.endpointConfigName = endpointConfigName;
    }

    public String getEndpointConfigName() {
        return this.endpointConfigName;
    }

    public CreateEndpointConfigRequest withEndpointConfigName(String endpointConfigName) {
        this.setEndpointConfigName(endpointConfigName);
        return this;
    }

    public List<ProductionVariant> getProductionVariants() {
        return this.productionVariants;
    }

    public void setProductionVariants(Collection<ProductionVariant> productionVariants) {
        if (productionVariants == null) {
            this.productionVariants = null;
            return;
        }
        this.productionVariants = new ArrayList<ProductionVariant>(productionVariants);
    }

    public CreateEndpointConfigRequest withProductionVariants(ProductionVariant ... productionVariants) {
        if (this.productionVariants == null) {
            this.setProductionVariants(new ArrayList<ProductionVariant>(productionVariants.length));
        }
        for (ProductionVariant ele : productionVariants) {
            this.productionVariants.add(ele);
        }
        return this;
    }

    public CreateEndpointConfigRequest withProductionVariants(Collection<ProductionVariant> productionVariants) {
        this.setProductionVariants(productionVariants);
        return this;
    }

    public void setDataCaptureConfig(DataCaptureConfig dataCaptureConfig) {
        this.dataCaptureConfig = dataCaptureConfig;
    }

    public DataCaptureConfig getDataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public CreateEndpointConfigRequest withDataCaptureConfig(DataCaptureConfig dataCaptureConfig) {
        this.setDataCaptureConfig(dataCaptureConfig);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateEndpointConfigRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateEndpointConfigRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateEndpointConfigRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setAsyncInferenceConfig(AsyncInferenceConfig asyncInferenceConfig) {
        this.asyncInferenceConfig = asyncInferenceConfig;
    }

    public AsyncInferenceConfig getAsyncInferenceConfig() {
        return this.asyncInferenceConfig;
    }

    public CreateEndpointConfigRequest withAsyncInferenceConfig(AsyncInferenceConfig asyncInferenceConfig) {
        this.setAsyncInferenceConfig(asyncInferenceConfig);
        return this;
    }

    public void setExplainerConfig(ExplainerConfig explainerConfig) {
        this.explainerConfig = explainerConfig;
    }

    public ExplainerConfig getExplainerConfig() {
        return this.explainerConfig;
    }

    public CreateEndpointConfigRequest withExplainerConfig(ExplainerConfig explainerConfig) {
        this.setExplainerConfig(explainerConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointConfigName() != null) {
            sb.append("EndpointConfigName: ").append(this.getEndpointConfigName()).append(",");
        }
        if (this.getProductionVariants() != null) {
            sb.append("ProductionVariants: ").append(this.getProductionVariants()).append(",");
        }
        if (this.getDataCaptureConfig() != null) {
            sb.append("DataCaptureConfig: ").append(this.getDataCaptureConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getAsyncInferenceConfig() != null) {
            sb.append("AsyncInferenceConfig: ").append(this.getAsyncInferenceConfig()).append(",");
        }
        if (this.getExplainerConfig() != null) {
            sb.append("ExplainerConfig: ").append(this.getExplainerConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointConfigRequest)) {
            return false;
        }
        CreateEndpointConfigRequest other = (CreateEndpointConfigRequest)obj;
        if (other.getEndpointConfigName() == null ^ this.getEndpointConfigName() == null) {
            return false;
        }
        if (other.getEndpointConfigName() != null && !other.getEndpointConfigName().equals(this.getEndpointConfigName())) {
            return false;
        }
        if (other.getProductionVariants() == null ^ this.getProductionVariants() == null) {
            return false;
        }
        if (other.getProductionVariants() != null && !other.getProductionVariants().equals(this.getProductionVariants())) {
            return false;
        }
        if (other.getDataCaptureConfig() == null ^ this.getDataCaptureConfig() == null) {
            return false;
        }
        if (other.getDataCaptureConfig() != null && !other.getDataCaptureConfig().equals(this.getDataCaptureConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getAsyncInferenceConfig() == null ^ this.getAsyncInferenceConfig() == null) {
            return false;
        }
        if (other.getAsyncInferenceConfig() != null && !other.getAsyncInferenceConfig().equals(this.getAsyncInferenceConfig())) {
            return false;
        }
        if (other.getExplainerConfig() == null ^ this.getExplainerConfig() == null) {
            return false;
        }
        return other.getExplainerConfig() == null || other.getExplainerConfig().equals(this.getExplainerConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointConfigName() == null ? 0 : this.getEndpointConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getProductionVariants() == null ? 0 : this.getProductionVariants().hashCode());
        hashCode = 31 * hashCode + (this.getDataCaptureConfig() == null ? 0 : this.getDataCaptureConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getAsyncInferenceConfig() == null ? 0 : this.getAsyncInferenceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getExplainerConfig() == null ? 0 : this.getExplainerConfig().hashCode());
        return hashCode;
    }

    public CreateEndpointConfigRequest clone() {
        return (CreateEndpointConfigRequest)super.clone();
    }
}

