/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.UpdateClusterRequest;
import com.amazonaws.services.snowball.model.transform.JobResourceJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.NotificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateClusterRequestMarshaller
implements Marshaller<Request<UpdateClusterRequest>, UpdateClusterRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateClusterRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateClusterRequest> marshall(UpdateClusterRequest updateClusterRequest) {
        if (updateClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateClusterRequest, "AmazonSnowball");
        request.addHeader("X-Amz-Target", "AWSIESnowballJobManagementService.UpdateCluster");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateClusterRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(updateClusterRequest.getClusterId());
            }
            if (updateClusterRequest.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(updateClusterRequest.getRoleARN());
            }
            if (updateClusterRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateClusterRequest.getDescription());
            }
            if (updateClusterRequest.getResources() != null) {
                jsonGenerator.writeFieldName("Resources");
                JobResourceJsonMarshaller.getInstance().marshall(updateClusterRequest.getResources(), jsonGenerator);
            }
            if (updateClusterRequest.getAddressId() != null) {
                jsonGenerator.writeFieldName("AddressId").writeValue(updateClusterRequest.getAddressId());
            }
            if (updateClusterRequest.getShippingOption() != null) {
                jsonGenerator.writeFieldName("ShippingOption").writeValue(updateClusterRequest.getShippingOption());
            }
            if (updateClusterRequest.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(updateClusterRequest.getNotification(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

