/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.ClusterMetadata;
import com.amazonaws.services.snowball.model.transform.JobResourceJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.NotificationJsonMarshaller;

public class ClusterMetadataJsonMarshaller {
    private static ClusterMetadataJsonMarshaller instance;

    public void marshall(ClusterMetadata clusterMetadata, StructuredJsonGenerator jsonGenerator) {
        if (clusterMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (clusterMetadata.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(clusterMetadata.getClusterId());
            }
            if (clusterMetadata.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(clusterMetadata.getDescription());
            }
            if (clusterMetadata.getKmsKeyARN() != null) {
                jsonGenerator.writeFieldName("KmsKeyARN").writeValue(clusterMetadata.getKmsKeyARN());
            }
            if (clusterMetadata.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(clusterMetadata.getRoleARN());
            }
            if (clusterMetadata.getClusterState() != null) {
                jsonGenerator.writeFieldName("ClusterState").writeValue(clusterMetadata.getClusterState());
            }
            if (clusterMetadata.getJobType() != null) {
                jsonGenerator.writeFieldName("JobType").writeValue(clusterMetadata.getJobType());
            }
            if (clusterMetadata.getSnowballType() != null) {
                jsonGenerator.writeFieldName("SnowballType").writeValue(clusterMetadata.getSnowballType());
            }
            if (clusterMetadata.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(clusterMetadata.getCreationDate());
            }
            if (clusterMetadata.getResources() != null) {
                jsonGenerator.writeFieldName("Resources");
                JobResourceJsonMarshaller.getInstance().marshall(clusterMetadata.getResources(), jsonGenerator);
            }
            if (clusterMetadata.getAddressId() != null) {
                jsonGenerator.writeFieldName("AddressId").writeValue(clusterMetadata.getAddressId());
            }
            if (clusterMetadata.getShippingOption() != null) {
                jsonGenerator.writeFieldName("ShippingOption").writeValue(clusterMetadata.getShippingOption());
            }
            if (clusterMetadata.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(clusterMetadata.getNotification(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ClusterMetadataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterMetadataJsonMarshaller();
        }
        return instance;
    }
}

