/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class CreateAssociationRequestMarshaller
implements Marshaller<Request<CreateAssociationRequest>, CreateAssociationRequest> {
    public Request<CreateAssociationRequest> marshall(CreateAssociationRequest createAssociationRequest) {
        if (createAssociationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAssociationRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.CreateAssociation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, List<String>> parametersMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createAssociationRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)createAssociationRequest.getName());
            }
            if (createAssociationRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value((Object)createAssociationRequest.getInstanceId());
            }
            if ((parametersMap = createAssociationRequest.getParameters()) != null) {
                jsonWriter.key("Parameters");
                jsonWriter.object();
                for (Map.Entry<String, List<String>> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonWriter.key(parametersMapValue.getKey());
                    jsonWriter.array();
                    for (String parametersMapValueList : parametersMapValue.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonWriter.value((Object)parametersMapValueList);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

