/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentParameter;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentStatus;
import com.amazonaws.services.simplesystemsmanagement.model.PlatformType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DocumentDescription
implements Serializable,
Cloneable {
    private String sha1;
    private String name;
    private Date createdDate;
    private String status;
    private String description;
    private SdkInternalList<DocumentParameter> parameters;
    private SdkInternalList<String> platformTypes;

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getSha1() {
        return this.sha1;
    }

    public DocumentDescription withSha1(String sha1) {
        this.setSha1(sha1);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DocumentDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public DocumentDescription withCreatedDate(Date createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DocumentDescription withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(DocumentStatus status) {
        this.status = status.toString();
    }

    public DocumentDescription withStatus(DocumentStatus status) {
        this.setStatus(status);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentDescription withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<DocumentParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new SdkInternalList();
        }
        return this.parameters;
    }

    public void setParameters(Collection<DocumentParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new SdkInternalList(parameters);
    }

    public DocumentDescription withParameters(DocumentParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters((Collection<DocumentParameter>)new SdkInternalList(parameters.length));
        }
        for (DocumentParameter ele : parameters) {
            this.parameters.add((Object)ele);
        }
        return this;
    }

    public DocumentDescription withParameters(Collection<DocumentParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public List<String> getPlatformTypes() {
        if (this.platformTypes == null) {
            this.platformTypes = new SdkInternalList();
        }
        return this.platformTypes;
    }

    public void setPlatformTypes(Collection<String> platformTypes) {
        if (platformTypes == null) {
            this.platformTypes = null;
            return;
        }
        this.platformTypes = new SdkInternalList(platformTypes);
    }

    public DocumentDescription withPlatformTypes(String ... platformTypes) {
        if (this.platformTypes == null) {
            this.setPlatformTypes((Collection<String>)new SdkInternalList(platformTypes.length));
        }
        for (String ele : platformTypes) {
            this.platformTypes.add((Object)ele);
        }
        return this;
    }

    public DocumentDescription withPlatformTypes(Collection<String> platformTypes) {
        this.setPlatformTypes(platformTypes);
        return this;
    }

    public DocumentDescription withPlatformTypes(PlatformType ... platformTypes) {
        SdkInternalList platformTypesCopy = new SdkInternalList(platformTypes.length);
        for (PlatformType value : platformTypes) {
            platformTypesCopy.add((Object)value.toString());
        }
        if (this.getPlatformTypes() == null) {
            this.setPlatformTypes((Collection<String>)platformTypesCopy);
        } else {
            this.getPlatformTypes().addAll((Collection<String>)platformTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSha1() != null) {
            sb.append("Sha1: " + this.getSha1() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: " + this.getCreatedDate() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters() + ",");
        }
        if (this.getPlatformTypes() != null) {
            sb.append("PlatformTypes: " + this.getPlatformTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDescription)) {
            return false;
        }
        DocumentDescription other = (DocumentDescription)obj;
        if (other.getSha1() == null ^ this.getSha1() == null) {
            return false;
        }
        if (other.getSha1() != null && !other.getSha1().equals(this.getSha1())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        if (other.getCreatedDate() != null && !other.getCreatedDate().equals(this.getCreatedDate())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getPlatformTypes() == null ^ this.getPlatformTypes() == null) {
            return false;
        }
        return other.getPlatformTypes() == null || other.getPlatformTypes().equals(this.getPlatformTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSha1() == null ? 0 : this.getSha1().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformTypes() == null ? 0 : this.getPlatformTypes().hashCode());
        return hashCode;
    }

    public DocumentDescription clone() {
        try {
            return (DocumentDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

