/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SendCommandRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<String> instanceIds;
    private String documentName;
    private Integer timeoutSeconds;
    private String comment;
    private Map<String, List<String>> parameters;
    private String outputS3BucketName;
    private String outputS3KeyPrefix;

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new SdkInternalList();
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        this.instanceIds = new SdkInternalList(instanceIds);
    }

    public SendCommandRequest withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.setInstanceIds((Collection<String>)new SdkInternalList(instanceIds.length));
        }
        for (String ele : instanceIds) {
            this.instanceIds.add((Object)ele);
        }
        return this;
    }

    public SendCommandRequest withInstanceIds(Collection<String> instanceIds) {
        this.setInstanceIds(instanceIds);
        return this;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public SendCommandRequest withDocumentName(String documentName) {
        this.setDocumentName(documentName);
        return this;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public SendCommandRequest withTimeoutSeconds(Integer timeoutSeconds) {
        this.setTimeoutSeconds(timeoutSeconds);
        return this;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public SendCommandRequest withComment(String comment) {
        this.setComment(comment);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public SendCommandRequest withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public SendCommandRequest addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public SendCommandRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setOutputS3BucketName(String outputS3BucketName) {
        this.outputS3BucketName = outputS3BucketName;
    }

    public String getOutputS3BucketName() {
        return this.outputS3BucketName;
    }

    public SendCommandRequest withOutputS3BucketName(String outputS3BucketName) {
        this.setOutputS3BucketName(outputS3BucketName);
        return this;
    }

    public void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
        this.outputS3KeyPrefix = outputS3KeyPrefix;
    }

    public String getOutputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public SendCommandRequest withOutputS3KeyPrefix(String outputS3KeyPrefix) {
        this.setOutputS3KeyPrefix(outputS3KeyPrefix);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: " + this.getInstanceIds() + ",");
        }
        if (this.getDocumentName() != null) {
            sb.append("DocumentName: " + this.getDocumentName() + ",");
        }
        if (this.getTimeoutSeconds() != null) {
            sb.append("TimeoutSeconds: " + this.getTimeoutSeconds() + ",");
        }
        if (this.getComment() != null) {
            sb.append("Comment: " + this.getComment() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters() + ",");
        }
        if (this.getOutputS3BucketName() != null) {
            sb.append("OutputS3BucketName: " + this.getOutputS3BucketName() + ",");
        }
        if (this.getOutputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: " + this.getOutputS3KeyPrefix());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandRequest)) {
            return false;
        }
        SendCommandRequest other = (SendCommandRequest)obj;
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        if (other.getInstanceIds() != null && !other.getInstanceIds().equals(this.getInstanceIds())) {
            return false;
        }
        if (other.getDocumentName() == null ^ this.getDocumentName() == null) {
            return false;
        }
        if (other.getDocumentName() != null && !other.getDocumentName().equals(this.getDocumentName())) {
            return false;
        }
        if (other.getTimeoutSeconds() == null ^ this.getTimeoutSeconds() == null) {
            return false;
        }
        if (other.getTimeoutSeconds() != null && !other.getTimeoutSeconds().equals(this.getTimeoutSeconds())) {
            return false;
        }
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getOutputS3BucketName() == null ^ this.getOutputS3BucketName() == null) {
            return false;
        }
        if (other.getOutputS3BucketName() != null && !other.getOutputS3BucketName().equals(this.getOutputS3BucketName())) {
            return false;
        }
        if (other.getOutputS3KeyPrefix() == null ^ this.getOutputS3KeyPrefix() == null) {
            return false;
        }
        return other.getOutputS3KeyPrefix() == null || other.getOutputS3KeyPrefix().equals(this.getOutputS3KeyPrefix());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentName() == null ? 0 : this.getDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutSeconds() == null ? 0 : this.getTimeoutSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getOutputS3BucketName() == null ? 0 : this.getOutputS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputS3KeyPrefix() == null ? 0 : this.getOutputS3KeyPrefix().hashCode());
        return hashCode;
    }

    public SendCommandRequest clone() {
        return (SendCommandRequest)super.clone();
    }
}

