/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.ComplianceExecutionSummary;
import com.amazonaws.services.simplesystemsmanagement.model.ComplianceItemEntry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutComplianceItemsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceId;
    private String resourceType;
    private String complianceType;
    private ComplianceExecutionSummary executionSummary;
    private SdkInternalList<ComplianceItemEntry> items;
    private String itemContentHash;

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public PutComplianceItemsRequest withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public PutComplianceItemsRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setComplianceType(String complianceType) {
        this.complianceType = complianceType;
    }

    public String getComplianceType() {
        return this.complianceType;
    }

    public PutComplianceItemsRequest withComplianceType(String complianceType) {
        this.setComplianceType(complianceType);
        return this;
    }

    public void setExecutionSummary(ComplianceExecutionSummary executionSummary) {
        this.executionSummary = executionSummary;
    }

    public ComplianceExecutionSummary getExecutionSummary() {
        return this.executionSummary;
    }

    public PutComplianceItemsRequest withExecutionSummary(ComplianceExecutionSummary executionSummary) {
        this.setExecutionSummary(executionSummary);
        return this;
    }

    public List<ComplianceItemEntry> getItems() {
        if (this.items == null) {
            this.items = new SdkInternalList();
        }
        return this.items;
    }

    public void setItems(Collection<ComplianceItemEntry> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new SdkInternalList(items);
    }

    public PutComplianceItemsRequest withItems(ComplianceItemEntry ... items) {
        if (this.items == null) {
            this.setItems((Collection<ComplianceItemEntry>)new SdkInternalList(items.length));
        }
        for (ComplianceItemEntry ele : items) {
            this.items.add((Object)ele);
        }
        return this;
    }

    public PutComplianceItemsRequest withItems(Collection<ComplianceItemEntry> items) {
        this.setItems(items);
        return this;
    }

    public void setItemContentHash(String itemContentHash) {
        this.itemContentHash = itemContentHash;
    }

    public String getItemContentHash() {
        return this.itemContentHash;
    }

    public PutComplianceItemsRequest withItemContentHash(String itemContentHash) {
        this.setItemContentHash(itemContentHash);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getComplianceType() != null) {
            sb.append("ComplianceType: ").append(this.getComplianceType()).append(",");
        }
        if (this.getExecutionSummary() != null) {
            sb.append("ExecutionSummary: ").append(this.getExecutionSummary()).append(",");
        }
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems()).append(",");
        }
        if (this.getItemContentHash() != null) {
            sb.append("ItemContentHash: ").append(this.getItemContentHash());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutComplianceItemsRequest)) {
            return false;
        }
        PutComplianceItemsRequest other = (PutComplianceItemsRequest)obj;
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getComplianceType() == null ^ this.getComplianceType() == null) {
            return false;
        }
        if (other.getComplianceType() != null && !other.getComplianceType().equals(this.getComplianceType())) {
            return false;
        }
        if (other.getExecutionSummary() == null ^ this.getExecutionSummary() == null) {
            return false;
        }
        if (other.getExecutionSummary() != null && !other.getExecutionSummary().equals(this.getExecutionSummary())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getItemContentHash() == null ^ this.getItemContentHash() == null) {
            return false;
        }
        return other.getItemContentHash() == null || other.getItemContentHash().equals(this.getItemContentHash());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getComplianceType() == null ? 0 : this.getComplianceType().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionSummary() == null ? 0 : this.getExecutionSummary().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getItemContentHash() == null ? 0 : this.getItemContentHash().hashCode());
        return hashCode;
    }

    public PutComplianceItemsRequest clone() {
        return (PutComplianceItemsRequest)super.clone();
    }
}

