/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.CommandFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListCommandsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String commandId;
    private String instanceId;
    private Integer maxResults;
    private String nextToken;
    private SdkInternalList<CommandFilter> filters;

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public ListCommandsRequest withCommandId(String commandId) {
        this.setCommandId(commandId);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ListCommandsRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListCommandsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCommandsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<CommandFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<CommandFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public ListCommandsRequest withFilters(CommandFilter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<CommandFilter>)new SdkInternalList(filters.length));
        }
        for (CommandFilter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public ListCommandsRequest withFilters(Collection<CommandFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommandId() != null) {
            sb.append("CommandId: ").append(this.getCommandId()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandsRequest)) {
            return false;
        }
        ListCommandsRequest other = (ListCommandsRequest)obj;
        if (other.getCommandId() == null ^ this.getCommandId() == null) {
            return false;
        }
        if (other.getCommandId() != null && !other.getCommandId().equals(this.getCommandId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommandId() == null ? 0 : this.getCommandId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public ListCommandsRequest clone() {
        return (ListCommandsRequest)super.clone();
    }
}

