/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationComplianceSeverity;
import com.amazonaws.services.simplesystemsmanagement.model.InstanceAssociationOutputLocation;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateAssociationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String documentVersion;
    private String instanceId;
    private Map<String, List<String>> parameters;
    private SdkInternalList<Target> targets;
    private String scheduleExpression;
    private InstanceAssociationOutputLocation outputLocation;
    private String associationName;
    private String maxErrors;
    private String maxConcurrency;
    private String complianceSeverity;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateAssociationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public CreateAssociationRequest withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CreateAssociationRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public CreateAssociationRequest withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public CreateAssociationRequest addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public CreateAssociationRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList(targets);
    }

    public CreateAssociationRequest withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets((Collection<Target>)new SdkInternalList(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add((Object)ele);
        }
        return this;
    }

    public CreateAssociationRequest withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setScheduleExpression(String scheduleExpression) {
        this.scheduleExpression = scheduleExpression;
    }

    public String getScheduleExpression() {
        return this.scheduleExpression;
    }

    public CreateAssociationRequest withScheduleExpression(String scheduleExpression) {
        this.setScheduleExpression(scheduleExpression);
        return this;
    }

    public void setOutputLocation(InstanceAssociationOutputLocation outputLocation) {
        this.outputLocation = outputLocation;
    }

    public InstanceAssociationOutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public CreateAssociationRequest withOutputLocation(InstanceAssociationOutputLocation outputLocation) {
        this.setOutputLocation(outputLocation);
        return this;
    }

    public void setAssociationName(String associationName) {
        this.associationName = associationName;
    }

    public String getAssociationName() {
        return this.associationName;
    }

    public CreateAssociationRequest withAssociationName(String associationName) {
        this.setAssociationName(associationName);
        return this;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public CreateAssociationRequest withMaxErrors(String maxErrors) {
        this.setMaxErrors(maxErrors);
        return this;
    }

    public void setMaxConcurrency(String maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public String getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public CreateAssociationRequest withMaxConcurrency(String maxConcurrency) {
        this.setMaxConcurrency(maxConcurrency);
        return this;
    }

    public void setComplianceSeverity(String complianceSeverity) {
        this.complianceSeverity = complianceSeverity;
    }

    public String getComplianceSeverity() {
        return this.complianceSeverity;
    }

    public CreateAssociationRequest withComplianceSeverity(String complianceSeverity) {
        this.setComplianceSeverity(complianceSeverity);
        return this;
    }

    public CreateAssociationRequest withComplianceSeverity(AssociationComplianceSeverity complianceSeverity) {
        this.complianceSeverity = complianceSeverity.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getScheduleExpression() != null) {
            sb.append("ScheduleExpression: ").append(this.getScheduleExpression()).append(",");
        }
        if (this.getOutputLocation() != null) {
            sb.append("OutputLocation: ").append(this.getOutputLocation()).append(",");
        }
        if (this.getAssociationName() != null) {
            sb.append("AssociationName: ").append(this.getAssociationName()).append(",");
        }
        if (this.getMaxErrors() != null) {
            sb.append("MaxErrors: ").append(this.getMaxErrors()).append(",");
        }
        if (this.getMaxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.getMaxConcurrency()).append(",");
        }
        if (this.getComplianceSeverity() != null) {
            sb.append("ComplianceSeverity: ").append(this.getComplianceSeverity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationRequest)) {
            return false;
        }
        CreateAssociationRequest other = (CreateAssociationRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getScheduleExpression() == null ^ this.getScheduleExpression() == null) {
            return false;
        }
        if (other.getScheduleExpression() != null && !other.getScheduleExpression().equals(this.getScheduleExpression())) {
            return false;
        }
        if (other.getOutputLocation() == null ^ this.getOutputLocation() == null) {
            return false;
        }
        if (other.getOutputLocation() != null && !other.getOutputLocation().equals(this.getOutputLocation())) {
            return false;
        }
        if (other.getAssociationName() == null ^ this.getAssociationName() == null) {
            return false;
        }
        if (other.getAssociationName() != null && !other.getAssociationName().equals(this.getAssociationName())) {
            return false;
        }
        if (other.getMaxErrors() == null ^ this.getMaxErrors() == null) {
            return false;
        }
        if (other.getMaxErrors() != null && !other.getMaxErrors().equals(this.getMaxErrors())) {
            return false;
        }
        if (other.getMaxConcurrency() == null ^ this.getMaxConcurrency() == null) {
            return false;
        }
        if (other.getMaxConcurrency() != null && !other.getMaxConcurrency().equals(this.getMaxConcurrency())) {
            return false;
        }
        if (other.getComplianceSeverity() == null ^ this.getComplianceSeverity() == null) {
            return false;
        }
        return other.getComplianceSeverity() == null || other.getComplianceSeverity().equals(this.getComplianceSeverity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getScheduleExpression() == null ? 0 : this.getScheduleExpression().hashCode());
        hashCode = 31 * hashCode + (this.getOutputLocation() == null ? 0 : this.getOutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationName() == null ? 0 : this.getAssociationName().hashCode());
        hashCode = 31 * hashCode + (this.getMaxErrors() == null ? 0 : this.getMaxErrors().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrency() == null ? 0 : this.getMaxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.getComplianceSeverity() == null ? 0 : this.getComplianceSeverity().hashCode());
        return hashCode;
    }

    public CreateAssociationRequest clone() {
        return (CreateAssociationRequest)super.clone();
    }
}

