/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.PatchFilterKey;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PatchFilter
implements Serializable,
Cloneable {
    private String key;
    private SdkInternalList<String> values;

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public PatchFilter withKey(String key) {
        this.setKey(key);
        return this;
    }

    public void setKey(PatchFilterKey key) {
        this.key = key.toString();
    }

    public PatchFilter withKey(PatchFilterKey key) {
        this.setKey(key);
        return this;
    }

    public List<String> getValues() {
        if (this.values == null) {
            this.values = new SdkInternalList();
        }
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new SdkInternalList(values);
    }

    public PatchFilter withValues(String ... values) {
        if (this.values == null) {
            this.setValues((Collection<String>)new SdkInternalList(values.length));
        }
        for (String ele : values) {
            this.values.add((Object)ele);
        }
        return this;
    }

    public PatchFilter withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKey() != null) {
            sb.append("Key: " + this.getKey() + ",");
        }
        if (this.getValues() != null) {
            sb.append("Values: " + this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchFilter)) {
            return false;
        }
        PatchFilter other = (PatchFilter)obj;
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public PatchFilter clone() {
        try {
            return (PatchFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

