/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeInstancePatchesRequest;
import com.amazonaws.services.simplesystemsmanagement.model.PatchOrchestratorFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchOrchestratorFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeInstancePatchesRequestMarshaller
implements Marshaller<Request<DescribeInstancePatchesRequest>, DescribeInstancePatchesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeInstancePatchesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeInstancePatchesRequest> marshall(DescribeInstancePatchesRequest describeInstancePatchesRequest) {
        if (describeInstancePatchesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstancePatchesRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.DescribeInstancePatches");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList filtersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeInstancePatchesRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(describeInstancePatchesRequest.getInstanceId());
            }
            if (!(filtersList = (SdkInternalList)describeInstancePatchesRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (PatchOrchestratorFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    PatchOrchestratorFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeInstancePatchesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeInstancePatchesRequest.getNextToken());
            }
            if (describeInstancePatchesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeInstancePatchesRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

