/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.MaintenanceWindowFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeMaintenanceWindowExecutionTaskInvocationsRequestMarshaller
implements Marshaller<Request<DescribeMaintenanceWindowExecutionTaskInvocationsRequest>, DescribeMaintenanceWindowExecutionTaskInvocationsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeMaintenanceWindowExecutionTaskInvocationsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeMaintenanceWindowExecutionTaskInvocationsRequest> marshall(DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest) {
        if (describeMaintenanceWindowExecutionTaskInvocationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeMaintenanceWindowExecutionTaskInvocationsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.DescribeMaintenanceWindowExecutionTaskInvocations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList filtersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeMaintenanceWindowExecutionTaskInvocationsRequest.getWindowExecutionId() != null) {
                jsonGenerator.writeFieldName("WindowExecutionId").writeValue(describeMaintenanceWindowExecutionTaskInvocationsRequest.getWindowExecutionId());
            }
            if (describeMaintenanceWindowExecutionTaskInvocationsRequest.getTaskId() != null) {
                jsonGenerator.writeFieldName("TaskId").writeValue(describeMaintenanceWindowExecutionTaskInvocationsRequest.getTaskId());
            }
            if (!(filtersList = (SdkInternalList)describeMaintenanceWindowExecutionTaskInvocationsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (MaintenanceWindowFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    MaintenanceWindowFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeMaintenanceWindowExecutionTaskInvocationsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeMaintenanceWindowExecutionTaskInvocationsRequest.getMaxResults().intValue());
            }
            if (describeMaintenanceWindowExecutionTaskInvocationsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeMaintenanceWindowExecutionTaskInvocationsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

