/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.GetInventorySchemaRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetInventorySchemaRequestMarshaller
implements Marshaller<Request<GetInventorySchemaRequest>, GetInventorySchemaRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetInventorySchemaRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetInventorySchemaRequest> marshall(GetInventorySchemaRequest getInventorySchemaRequest) {
        if (getInventorySchemaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getInventorySchemaRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.GetInventorySchema");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getInventorySchemaRequest.getTypeName() != null) {
                jsonGenerator.writeFieldName("TypeName").writeValue(getInventorySchemaRequest.getTypeName());
            }
            if (getInventorySchemaRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(getInventorySchemaRequest.getNextToken());
            }
            if (getInventorySchemaRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(getInventorySchemaRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

