/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.RegisterTargetWithMaintenanceWindowRequest;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.TargetJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RegisterTargetWithMaintenanceWindowRequestMarshaller
implements Marshaller<Request<RegisterTargetWithMaintenanceWindowRequest>, RegisterTargetWithMaintenanceWindowRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterTargetWithMaintenanceWindowRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RegisterTargetWithMaintenanceWindowRequest> marshall(RegisterTargetWithMaintenanceWindowRequest registerTargetWithMaintenanceWindowRequest) {
        if (registerTargetWithMaintenanceWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerTargetWithMaintenanceWindowRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.RegisterTargetWithMaintenanceWindow");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList targetsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerTargetWithMaintenanceWindowRequest.getWindowId() != null) {
                jsonGenerator.writeFieldName("WindowId").writeValue(registerTargetWithMaintenanceWindowRequest.getWindowId());
            }
            if (registerTargetWithMaintenanceWindowRequest.getResourceType() != null) {
                jsonGenerator.writeFieldName("ResourceType").writeValue(registerTargetWithMaintenanceWindowRequest.getResourceType());
            }
            if (!(targetsList = (SdkInternalList)registerTargetWithMaintenanceWindowRequest.getTargets()).isEmpty() || !targetsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Targets");
                jsonGenerator.writeStartArray();
                for (Target targetsListValue : targetsList) {
                    if (targetsListValue == null) continue;
                    TargetJsonMarshaller.getInstance().marshall(targetsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (registerTargetWithMaintenanceWindowRequest.getOwnerInformation() != null) {
                jsonGenerator.writeFieldName("OwnerInformation").writeValue(registerTargetWithMaintenanceWindowRequest.getOwnerInformation());
            }
            jsonGenerator.writeFieldName("ClientToken").writeValue(IdempotentUtils.resolveString((String)registerTargetWithMaintenanceWindowRequest.getClientToken()));
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

