/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InstanceAssociationOutputLocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class UpdateAssociationRequestMarshaller
implements Marshaller<Request<UpdateAssociationRequest>, UpdateAssociationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateAssociationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateAssociationRequest> marshall(UpdateAssociationRequest updateAssociationRequest) {
        if (updateAssociationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateAssociationRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.UpdateAssociation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, List<String>> parametersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateAssociationRequest.getAssociationId() != null) {
                jsonGenerator.writeFieldName("AssociationId").writeValue(updateAssociationRequest.getAssociationId());
            }
            if ((parametersMap = updateAssociationRequest.getParameters()) != null) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(parametersMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String parametersMapValueList : parametersMapValue.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonGenerator.writeValue(parametersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (updateAssociationRequest.getDocumentVersion() != null) {
                jsonGenerator.writeFieldName("DocumentVersion").writeValue(updateAssociationRequest.getDocumentVersion());
            }
            if (updateAssociationRequest.getScheduleExpression() != null) {
                jsonGenerator.writeFieldName("ScheduleExpression").writeValue(updateAssociationRequest.getScheduleExpression());
            }
            if (updateAssociationRequest.getOutputLocation() != null) {
                jsonGenerator.writeFieldName("OutputLocation");
                InstanceAssociationOutputLocationJsonMarshaller.getInstance().marshall(updateAssociationRequest.getOutputLocation(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

