/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.Activation;

public class ActivationJsonMarshaller {
    private static ActivationJsonMarshaller instance;

    public void marshall(Activation activation, StructuredJsonGenerator jsonGenerator) {
        if (activation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (activation.getActivationId() != null) {
                jsonGenerator.writeFieldName("ActivationId").writeValue(activation.getActivationId());
            }
            if (activation.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(activation.getDescription());
            }
            if (activation.getDefaultInstanceName() != null) {
                jsonGenerator.writeFieldName("DefaultInstanceName").writeValue(activation.getDefaultInstanceName());
            }
            if (activation.getIamRole() != null) {
                jsonGenerator.writeFieldName("IamRole").writeValue(activation.getIamRole());
            }
            if (activation.getRegistrationLimit() != null) {
                jsonGenerator.writeFieldName("RegistrationLimit").writeValue(activation.getRegistrationLimit().intValue());
            }
            if (activation.getRegistrationsCount() != null) {
                jsonGenerator.writeFieldName("RegistrationsCount").writeValue(activation.getRegistrationsCount().intValue());
            }
            if (activation.getExpirationDate() != null) {
                jsonGenerator.writeFieldName("ExpirationDate").writeValue(activation.getExpirationDate());
            }
            if (activation.getExpired() != null) {
                jsonGenerator.writeFieldName("Expired").writeValue(activation.getExpired().booleanValue());
            }
            if (activation.getCreatedDate() != null) {
                jsonGenerator.writeFieldName("CreatedDate").writeValue(activation.getCreatedDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActivationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActivationJsonMarshaller();
        }
        return instance;
    }
}

