/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DescribePatchBaselinesRequest;
import com.amazonaws.services.simplesystemsmanagement.model.PatchOrchestratorFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchOrchestratorFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribePatchBaselinesRequestMarshaller
implements Marshaller<Request<DescribePatchBaselinesRequest>, DescribePatchBaselinesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribePatchBaselinesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribePatchBaselinesRequest> marshall(DescribePatchBaselinesRequest describePatchBaselinesRequest) {
        if (describePatchBaselinesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describePatchBaselinesRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.DescribePatchBaselines");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList filtersList = (SdkInternalList)describePatchBaselinesRequest.getFilters();
            if (!filtersList.isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (PatchOrchestratorFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    PatchOrchestratorFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (describePatchBaselinesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describePatchBaselinesRequest.getMaxResults().intValue());
            }
            if (describePatchBaselinesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describePatchBaselinesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

