/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryItem;
import com.amazonaws.services.simplesystemsmanagement.model.PutInventoryRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InventoryItemJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutInventoryRequestMarshaller
implements Marshaller<Request<PutInventoryRequest>, PutInventoryRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutInventoryRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutInventoryRequest> marshall(PutInventoryRequest putInventoryRequest) {
        if (putInventoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putInventoryRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.PutInventory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList itemsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putInventoryRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(putInventoryRequest.getInstanceId());
            }
            if (!(itemsList = (SdkInternalList)putInventoryRequest.getItems()).isEmpty() || !itemsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Items");
                jsonGenerator.writeStartArray();
                for (InventoryItem itemsListValue : itemsList) {
                    if (itemsListValue == null) continue;
                    InventoryItemJsonMarshaller.getInstance().marshall(itemsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

