/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.ExecutionMode;
import com.amazonaws.services.simplesystemsmanagement.model.Tag;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.TargetLocation;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartAutomationExecutionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String documentName;
    private String documentVersion;
    private Map<String, List<String>> parameters;
    private String clientToken;
    private String mode;
    private String targetParameterName;
    private SdkInternalList<Target> targets;
    private SdkInternalList<Map<String, List<String>>> targetMaps;
    private String maxConcurrency;
    private String maxErrors;
    private SdkInternalList<TargetLocation> targetLocations;
    private SdkInternalList<Tag> tags;

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public StartAutomationExecutionRequest withDocumentName(String documentName) {
        this.setDocumentName(documentName);
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public StartAutomationExecutionRequest withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public StartAutomationExecutionRequest withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public StartAutomationExecutionRequest addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public StartAutomationExecutionRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public StartAutomationExecutionRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public StartAutomationExecutionRequest withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public StartAutomationExecutionRequest withMode(ExecutionMode mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setTargetParameterName(String targetParameterName) {
        this.targetParameterName = targetParameterName;
    }

    public String getTargetParameterName() {
        return this.targetParameterName;
    }

    public StartAutomationExecutionRequest withTargetParameterName(String targetParameterName) {
        this.setTargetParameterName(targetParameterName);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList(targets);
    }

    public StartAutomationExecutionRequest withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets((Collection<Target>)new SdkInternalList(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add((Object)ele);
        }
        return this;
    }

    public StartAutomationExecutionRequest withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public List<Map<String, List<String>>> getTargetMaps() {
        if (this.targetMaps == null) {
            this.targetMaps = new SdkInternalList();
        }
        return this.targetMaps;
    }

    public void setTargetMaps(Collection<Map<String, List<String>>> targetMaps) {
        if (targetMaps == null) {
            this.targetMaps = null;
            return;
        }
        this.targetMaps = new SdkInternalList(targetMaps);
    }

    public StartAutomationExecutionRequest withTargetMaps(Map<String, List<String>> ... targetMaps) {
        if (this.targetMaps == null) {
            this.setTargetMaps((Collection<Map<String, List<String>>>)new SdkInternalList(targetMaps.length));
        }
        for (Map<String, List<String>> ele : targetMaps) {
            this.targetMaps.add(ele);
        }
        return this;
    }

    public StartAutomationExecutionRequest withTargetMaps(Collection<Map<String, List<String>>> targetMaps) {
        this.setTargetMaps(targetMaps);
        return this;
    }

    public void setMaxConcurrency(String maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public String getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public StartAutomationExecutionRequest withMaxConcurrency(String maxConcurrency) {
        this.setMaxConcurrency(maxConcurrency);
        return this;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public StartAutomationExecutionRequest withMaxErrors(String maxErrors) {
        this.setMaxErrors(maxErrors);
        return this;
    }

    public List<TargetLocation> getTargetLocations() {
        if (this.targetLocations == null) {
            this.targetLocations = new SdkInternalList();
        }
        return this.targetLocations;
    }

    public void setTargetLocations(Collection<TargetLocation> targetLocations) {
        if (targetLocations == null) {
            this.targetLocations = null;
            return;
        }
        this.targetLocations = new SdkInternalList(targetLocations);
    }

    public StartAutomationExecutionRequest withTargetLocations(TargetLocation ... targetLocations) {
        if (this.targetLocations == null) {
            this.setTargetLocations((Collection<TargetLocation>)new SdkInternalList(targetLocations.length));
        }
        for (TargetLocation ele : targetLocations) {
            this.targetLocations.add((Object)ele);
        }
        return this;
    }

    public StartAutomationExecutionRequest withTargetLocations(Collection<TargetLocation> targetLocations) {
        this.setTargetLocations(targetLocations);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public StartAutomationExecutionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public StartAutomationExecutionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentName() != null) {
            sb.append("DocumentName: ").append(this.getDocumentName()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getTargetParameterName() != null) {
            sb.append("TargetParameterName: ").append(this.getTargetParameterName()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getTargetMaps() != null) {
            sb.append("TargetMaps: ").append(this.getTargetMaps()).append(",");
        }
        if (this.getMaxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.getMaxConcurrency()).append(",");
        }
        if (this.getMaxErrors() != null) {
            sb.append("MaxErrors: ").append(this.getMaxErrors()).append(",");
        }
        if (this.getTargetLocations() != null) {
            sb.append("TargetLocations: ").append(this.getTargetLocations()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomationExecutionRequest)) {
            return false;
        }
        StartAutomationExecutionRequest other = (StartAutomationExecutionRequest)obj;
        if (other.getDocumentName() == null ^ this.getDocumentName() == null) {
            return false;
        }
        if (other.getDocumentName() != null && !other.getDocumentName().equals(this.getDocumentName())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getTargetParameterName() == null ^ this.getTargetParameterName() == null) {
            return false;
        }
        if (other.getTargetParameterName() != null && !other.getTargetParameterName().equals(this.getTargetParameterName())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getTargetMaps() == null ^ this.getTargetMaps() == null) {
            return false;
        }
        if (other.getTargetMaps() != null && !other.getTargetMaps().equals(this.getTargetMaps())) {
            return false;
        }
        if (other.getMaxConcurrency() == null ^ this.getMaxConcurrency() == null) {
            return false;
        }
        if (other.getMaxConcurrency() != null && !other.getMaxConcurrency().equals(this.getMaxConcurrency())) {
            return false;
        }
        if (other.getMaxErrors() == null ^ this.getMaxErrors() == null) {
            return false;
        }
        if (other.getMaxErrors() != null && !other.getMaxErrors().equals(this.getMaxErrors())) {
            return false;
        }
        if (other.getTargetLocations() == null ^ this.getTargetLocations() == null) {
            return false;
        }
        if (other.getTargetLocations() != null && !other.getTargetLocations().equals(this.getTargetLocations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentName() == null ? 0 : this.getDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getTargetParameterName() == null ? 0 : this.getTargetParameterName().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTargetMaps() == null ? 0 : this.getTargetMaps().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrency() == null ? 0 : this.getMaxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.getMaxErrors() == null ? 0 : this.getMaxErrors().hashCode());
        hashCode = 31 * hashCode + (this.getTargetLocations() == null ? 0 : this.getTargetLocations().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StartAutomationExecutionRequest clone() {
        return (StartAutomationExecutionRequest)super.clone();
    }
}

