/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.DependentEntity;
import java.util.List;

@SdkInternalApi
public class DependentEntityMarshaller {
    private static final MarshallingInfo<String> RELATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelationType").build();
    private static final MarshallingInfo<List> DEPENDENTRESOURCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DependentResourceIds").build();
    private static final DependentEntityMarshaller instance = new DependentEntityMarshaller();

    public static DependentEntityMarshaller getInstance() {
        return instance;
    }

    public void marshall(DependentEntity dependentEntity, ProtocolMarshaller protocolMarshaller) {
        if (dependentEntity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dependentEntity.getRelationType(), RELATIONTYPE_BINDING);
            protocolMarshaller.marshall(dependentEntity.getDependentResourceIds(), DEPENDENTRESOURCEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

