/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.ComponentStatus;
import com.amazonaws.services.ssmsap.model.ComponentType;
import com.amazonaws.services.ssmsap.model.Host;
import com.amazonaws.services.ssmsap.model.transform.ComponentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Component
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentId;
    private String applicationId;
    private String componentType;
    private String status;
    private List<String> databases;
    private List<Host> hosts;
    private String primaryHost;
    private Date lastUpdated;

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Component withComponentId(String componentId) {
        this.setComponentId(componentId);
        return this;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Component withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public Component withComponentType(String componentType) {
        this.setComponentType(componentType);
        return this;
    }

    public Component withComponentType(ComponentType componentType) {
        this.componentType = componentType.toString();
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Component withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Component withStatus(ComponentStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<String> getDatabases() {
        return this.databases;
    }

    public void setDatabases(Collection<String> databases) {
        if (databases == null) {
            this.databases = null;
            return;
        }
        this.databases = new ArrayList<String>(databases);
    }

    public Component withDatabases(String ... databases) {
        if (this.databases == null) {
            this.setDatabases(new ArrayList<String>(databases.length));
        }
        for (String ele : databases) {
            this.databases.add(ele);
        }
        return this;
    }

    public Component withDatabases(Collection<String> databases) {
        this.setDatabases(databases);
        return this;
    }

    public List<Host> getHosts() {
        return this.hosts;
    }

    public void setHosts(Collection<Host> hosts) {
        if (hosts == null) {
            this.hosts = null;
            return;
        }
        this.hosts = new ArrayList<Host>(hosts);
    }

    public Component withHosts(Host ... hosts) {
        if (this.hosts == null) {
            this.setHosts(new ArrayList<Host>(hosts.length));
        }
        for (Host ele : hosts) {
            this.hosts.add(ele);
        }
        return this;
    }

    public Component withHosts(Collection<Host> hosts) {
        this.setHosts(hosts);
        return this;
    }

    public void setPrimaryHost(String primaryHost) {
        this.primaryHost = primaryHost;
    }

    public String getPrimaryHost() {
        return this.primaryHost;
    }

    public Component withPrimaryHost(String primaryHost) {
        this.setPrimaryHost(primaryHost);
        return this;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public Component withLastUpdated(Date lastUpdated) {
        this.setLastUpdated(lastUpdated);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentId() != null) {
            sb.append("ComponentId: ").append(this.getComponentId()).append(",");
        }
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getComponentType() != null) {
            sb.append("ComponentType: ").append(this.getComponentType()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getDatabases() != null) {
            sb.append("Databases: ").append(this.getDatabases()).append(",");
        }
        if (this.getHosts() != null) {
            sb.append("Hosts: ").append(this.getHosts()).append(",");
        }
        if (this.getPrimaryHost() != null) {
            sb.append("PrimaryHost: ").append(this.getPrimaryHost()).append(",");
        }
        if (this.getLastUpdated() != null) {
            sb.append("LastUpdated: ").append(this.getLastUpdated());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component)obj;
        if (other.getComponentId() == null ^ this.getComponentId() == null) {
            return false;
        }
        if (other.getComponentId() != null && !other.getComponentId().equals(this.getComponentId())) {
            return false;
        }
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getComponentType() == null ^ this.getComponentType() == null) {
            return false;
        }
        if (other.getComponentType() != null && !other.getComponentType().equals(this.getComponentType())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDatabases() == null ^ this.getDatabases() == null) {
            return false;
        }
        if (other.getDatabases() != null && !other.getDatabases().equals(this.getDatabases())) {
            return false;
        }
        if (other.getHosts() == null ^ this.getHosts() == null) {
            return false;
        }
        if (other.getHosts() != null && !other.getHosts().equals(this.getHosts())) {
            return false;
        }
        if (other.getPrimaryHost() == null ^ this.getPrimaryHost() == null) {
            return false;
        }
        if (other.getPrimaryHost() != null && !other.getPrimaryHost().equals(this.getPrimaryHost())) {
            return false;
        }
        if (other.getLastUpdated() == null ^ this.getLastUpdated() == null) {
            return false;
        }
        return other.getLastUpdated() == null || other.getLastUpdated().equals(this.getLastUpdated());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentId() == null ? 0 : this.getComponentId().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getComponentType() == null ? 0 : this.getComponentType().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDatabases() == null ? 0 : this.getDatabases().hashCode());
        hashCode = 31 * hashCode + (this.getHosts() == null ? 0 : this.getHosts().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryHost() == null ? 0 : this.getPrimaryHost().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdated() == null ? 0 : this.getLastUpdated().hashCode());
        return hashCode;
    }

    public Component clone() {
        try {
            return (Component)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

