/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.ComponentType;
import com.amazonaws.services.ssmsap.model.transform.ComponentSummaryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ComponentSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationId;
    private String componentId;
    private String componentType;
    private Map<String, String> tags;
    private String arn;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public ComponentSummary withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public ComponentSummary withComponentId(String componentId) {
        this.setComponentId(componentId);
        return this;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public ComponentSummary withComponentType(String componentType) {
        this.setComponentType(componentType);
        return this;
    }

    public ComponentSummary withComponentType(ComponentType componentType) {
        this.componentType = componentType.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ComponentSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ComponentSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ComponentSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ComponentSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getComponentId() != null) {
            sb.append("ComponentId: ").append(this.getComponentId()).append(",");
        }
        if (this.getComponentType() != null) {
            sb.append("ComponentType: ").append(this.getComponentType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentSummary)) {
            return false;
        }
        ComponentSummary other = (ComponentSummary)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getComponentId() == null ^ this.getComponentId() == null) {
            return false;
        }
        if (other.getComponentId() != null && !other.getComponentId().equals(this.getComponentId())) {
            return false;
        }
        if (other.getComponentType() == null ^ this.getComponentType() == null) {
            return false;
        }
        if (other.getComponentType() != null && !other.getComponentType().equals(this.getComponentType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        return other.getArn() == null || other.getArn().equals(this.getArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getComponentId() == null ? 0 : this.getComponentId().hashCode());
        hashCode = 31 * hashCode + (this.getComponentType() == null ? 0 : this.getComponentType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        return hashCode;
    }

    public ComponentSummary clone() {
        try {
            return (ComponentSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

