/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.support.AWSSupportAsync;
import com.amazonaws.services.support.AWSSupportClient;
import com.amazonaws.services.support.model.AddAttachmentsToSetRequest;
import com.amazonaws.services.support.model.AddAttachmentsToSetResult;
import com.amazonaws.services.support.model.AddCommunicationToCaseRequest;
import com.amazonaws.services.support.model.AddCommunicationToCaseResult;
import com.amazonaws.services.support.model.CreateCaseRequest;
import com.amazonaws.services.support.model.CreateCaseResult;
import com.amazonaws.services.support.model.DescribeAttachmentRequest;
import com.amazonaws.services.support.model.DescribeAttachmentResult;
import com.amazonaws.services.support.model.DescribeCasesRequest;
import com.amazonaws.services.support.model.DescribeCasesResult;
import com.amazonaws.services.support.model.DescribeCommunicationsRequest;
import com.amazonaws.services.support.model.DescribeCommunicationsResult;
import com.amazonaws.services.support.model.DescribeServicesRequest;
import com.amazonaws.services.support.model.DescribeServicesResult;
import com.amazonaws.services.support.model.DescribeSeverityLevelsRequest;
import com.amazonaws.services.support.model.DescribeSeverityLevelsResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksResult;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckRequest;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckResult;
import com.amazonaws.services.support.model.ResolveCaseRequest;
import com.amazonaws.services.support.model.ResolveCaseResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSSupportAsyncClient
extends AWSSupportClient
implements AWSSupportAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSSupportAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSSupportAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSupportAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSSupportAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSSupportAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSSupportAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSSupportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSSupportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSupportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckRefreshStatusesResult> describeTrustedAdvisorCheckRefreshStatusesAsync(final DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorCheckRefreshStatusesResult>(){

            @Override
            public DescribeTrustedAdvisorCheckRefreshStatusesResult call() throws Exception {
                return AWSSupportAsyncClient.this.describeTrustedAdvisorCheckRefreshStatuses(describeTrustedAdvisorCheckRefreshStatusesRequest);
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckRefreshStatusesResult> describeTrustedAdvisorCheckRefreshStatusesAsync(final DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest, final AsyncHandler<DescribeTrustedAdvisorCheckRefreshStatusesRequest, DescribeTrustedAdvisorCheckRefreshStatusesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorCheckRefreshStatusesResult>(){

            @Override
            public DescribeTrustedAdvisorCheckRefreshStatusesResult call() throws Exception {
                DescribeTrustedAdvisorCheckRefreshStatusesResult result;
                try {
                    result = AWSSupportAsyncClient.this.describeTrustedAdvisorCheckRefreshStatuses(describeTrustedAdvisorCheckRefreshStatusesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTrustedAdvisorCheckRefreshStatusesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCasesResult> describeCasesAsync(final DescribeCasesRequest describeCasesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCasesResult>(){

            @Override
            public DescribeCasesResult call() throws Exception {
                return AWSSupportAsyncClient.this.describeCases(describeCasesRequest);
            }
        });
    }

    @Override
    public Future<DescribeCasesResult> describeCasesAsync(final DescribeCasesRequest describeCasesRequest, final AsyncHandler<DescribeCasesRequest, DescribeCasesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCasesResult>(){

            @Override
            public DescribeCasesResult call() throws Exception {
                DescribeCasesResult result;
                try {
                    result = AWSSupportAsyncClient.this.describeCases(describeCasesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeCasesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<AddAttachmentsToSetResult> addAttachmentsToSetAsync(final AddAttachmentsToSetRequest addAttachmentsToSetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddAttachmentsToSetResult>(){

            @Override
            public AddAttachmentsToSetResult call() throws Exception {
                return AWSSupportAsyncClient.this.addAttachmentsToSet(addAttachmentsToSetRequest);
            }
        });
    }

    @Override
    public Future<AddAttachmentsToSetResult> addAttachmentsToSetAsync(final AddAttachmentsToSetRequest addAttachmentsToSetRequest, final AsyncHandler<AddAttachmentsToSetRequest, AddAttachmentsToSetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddAttachmentsToSetResult>(){

            @Override
            public AddAttachmentsToSetResult call() throws Exception {
                AddAttachmentsToSetResult result;
                try {
                    result = AWSSupportAsyncClient.this.addAttachmentsToSet(addAttachmentsToSetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)addAttachmentsToSetRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSeverityLevelsResult> describeSeverityLevelsAsync(final DescribeSeverityLevelsRequest describeSeverityLevelsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSeverityLevelsResult>(){

            @Override
            public DescribeSeverityLevelsResult call() throws Exception {
                return AWSSupportAsyncClient.this.describeSeverityLevels(describeSeverityLevelsRequest);
            }
        });
    }

    @Override
    public Future<DescribeSeverityLevelsResult> describeSeverityLevelsAsync(final DescribeSeverityLevelsRequest describeSeverityLevelsRequest, final AsyncHandler<DescribeSeverityLevelsRequest, DescribeSeverityLevelsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSeverityLevelsResult>(){

            @Override
            public DescribeSeverityLevelsResult call() throws Exception {
                DescribeSeverityLevelsResult result;
                try {
                    result = AWSSupportAsyncClient.this.describeSeverityLevels(describeSeverityLevelsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeSeverityLevelsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCommunicationsResult> describeCommunicationsAsync(final DescribeCommunicationsRequest describeCommunicationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCommunicationsResult>(){

            @Override
            public DescribeCommunicationsResult call() throws Exception {
                return AWSSupportAsyncClient.this.describeCommunications(describeCommunicationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCommunicationsResult> describeCommunicationsAsync(final DescribeCommunicationsRequest describeCommunicationsRequest, final AsyncHandler<DescribeCommunicationsRequest, DescribeCommunicationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCommunicationsResult>(){

            @Override
            public DescribeCommunicationsResult call() throws Exception {
                DescribeCommunicationsResult result;
                try {
                    result = AWSSupportAsyncClient.this.describeCommunications(describeCommunicationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeCommunicationsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAttachmentResult> describeAttachmentAsync(final DescribeAttachmentRequest describeAttachmentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAttachmentResult>(){

            @Override
            public DescribeAttachmentResult call() throws Exception {
                return AWSSupportAsyncClient.this.describeAttachment(describeAttachmentRequest);
            }
        });
    }

    @Override
    public Future<DescribeAttachmentResult> describeAttachmentAsync(final DescribeAttachmentRequest describeAttachmentRequest, final AsyncHandler<DescribeAttachmentRequest, DescribeAttachmentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAttachmentResult>(){

            @Override
            public DescribeAttachmentResult call() throws Exception {
                DescribeAttachmentResult result;
                try {
                    result = AWSSupportAsyncClient.this.describeAttachment(describeAttachmentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeAttachmentRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ResolveCaseResult> resolveCaseAsync(final ResolveCaseRequest resolveCaseRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResolveCaseResult>(){

            @Override
            public ResolveCaseResult call() throws Exception {
                return AWSSupportAsyncClient.this.resolveCase(resolveCaseRequest);
            }
        });
    }

    @Override
    public Future<ResolveCaseResult> resolveCaseAsync(final ResolveCaseRequest resolveCaseRequest, final AsyncHandler<ResolveCaseRequest, ResolveCaseResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResolveCaseResult>(){

            @Override
            public ResolveCaseResult call() throws Exception {
                ResolveCaseResult result;
                try {
                    result = AWSSupportAsyncClient.this.resolveCase(resolveCaseRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)resolveCaseRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(final DescribeServicesRequest describeServicesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeServicesResult>(){

            @Override
            public DescribeServicesResult call() throws Exception {
                return AWSSupportAsyncClient.this.describeServices(describeServicesRequest);
            }
        });
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(final DescribeServicesRequest describeServicesRequest, final AsyncHandler<DescribeServicesRequest, DescribeServicesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeServicesResult>(){

            @Override
            public DescribeServicesResult call() throws Exception {
                DescribeServicesResult result;
                try {
                    result = AWSSupportAsyncClient.this.describeServices(describeServicesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeServicesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<AddCommunicationToCaseResult> addCommunicationToCaseAsync(final AddCommunicationToCaseRequest addCommunicationToCaseRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddCommunicationToCaseResult>(){

            @Override
            public AddCommunicationToCaseResult call() throws Exception {
                return AWSSupportAsyncClient.this.addCommunicationToCase(addCommunicationToCaseRequest);
            }
        });
    }

    @Override
    public Future<AddCommunicationToCaseResult> addCommunicationToCaseAsync(final AddCommunicationToCaseRequest addCommunicationToCaseRequest, final AsyncHandler<AddCommunicationToCaseRequest, AddCommunicationToCaseResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddCommunicationToCaseResult>(){

            @Override
            public AddCommunicationToCaseResult call() throws Exception {
                AddCommunicationToCaseResult result;
                try {
                    result = AWSSupportAsyncClient.this.addCommunicationToCase(addCommunicationToCaseRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)addCommunicationToCaseRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateCaseResult> createCaseAsync(final CreateCaseRequest createCaseRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateCaseResult>(){

            @Override
            public CreateCaseResult call() throws Exception {
                return AWSSupportAsyncClient.this.createCase(createCaseRequest);
            }
        });
    }

    @Override
    public Future<CreateCaseResult> createCaseAsync(final CreateCaseRequest createCaseRequest, final AsyncHandler<CreateCaseRequest, CreateCaseResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateCaseResult>(){

            @Override
            public CreateCaseResult call() throws Exception {
                CreateCaseResult result;
                try {
                    result = AWSSupportAsyncClient.this.createCase(createCaseRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createCaseRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorChecksResult> describeTrustedAdvisorChecksAsync(final DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorChecksResult>(){

            @Override
            public DescribeTrustedAdvisorChecksResult call() throws Exception {
                return AWSSupportAsyncClient.this.describeTrustedAdvisorChecks(describeTrustedAdvisorChecksRequest);
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorChecksResult> describeTrustedAdvisorChecksAsync(final DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest, final AsyncHandler<DescribeTrustedAdvisorChecksRequest, DescribeTrustedAdvisorChecksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorChecksResult>(){

            @Override
            public DescribeTrustedAdvisorChecksResult call() throws Exception {
                DescribeTrustedAdvisorChecksResult result;
                try {
                    result = AWSSupportAsyncClient.this.describeTrustedAdvisorChecks(describeTrustedAdvisorChecksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTrustedAdvisorChecksRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckResultResult> describeTrustedAdvisorCheckResultAsync(final DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorCheckResultResult>(){

            @Override
            public DescribeTrustedAdvisorCheckResultResult call() throws Exception {
                return AWSSupportAsyncClient.this.describeTrustedAdvisorCheckResult(describeTrustedAdvisorCheckResultRequest);
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckResultResult> describeTrustedAdvisorCheckResultAsync(final DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest, final AsyncHandler<DescribeTrustedAdvisorCheckResultRequest, DescribeTrustedAdvisorCheckResultResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorCheckResultResult>(){

            @Override
            public DescribeTrustedAdvisorCheckResultResult call() throws Exception {
                DescribeTrustedAdvisorCheckResultResult result;
                try {
                    result = AWSSupportAsyncClient.this.describeTrustedAdvisorCheckResult(describeTrustedAdvisorCheckResultRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTrustedAdvisorCheckResultRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RefreshTrustedAdvisorCheckResult> refreshTrustedAdvisorCheckAsync(final RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RefreshTrustedAdvisorCheckResult>(){

            @Override
            public RefreshTrustedAdvisorCheckResult call() throws Exception {
                return AWSSupportAsyncClient.this.refreshTrustedAdvisorCheck(refreshTrustedAdvisorCheckRequest);
            }
        });
    }

    @Override
    public Future<RefreshTrustedAdvisorCheckResult> refreshTrustedAdvisorCheckAsync(final RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest, final AsyncHandler<RefreshTrustedAdvisorCheckRequest, RefreshTrustedAdvisorCheckResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RefreshTrustedAdvisorCheckResult>(){

            @Override
            public RefreshTrustedAdvisorCheckResult call() throws Exception {
                RefreshTrustedAdvisorCheckResult result;
                try {
                    result = AWSSupportAsyncClient.this.refreshTrustedAdvisorCheck(refreshTrustedAdvisorCheckRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)refreshTrustedAdvisorCheckRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckSummariesResult> describeTrustedAdvisorCheckSummariesAsync(final DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorCheckSummariesResult>(){

            @Override
            public DescribeTrustedAdvisorCheckSummariesResult call() throws Exception {
                return AWSSupportAsyncClient.this.describeTrustedAdvisorCheckSummaries(describeTrustedAdvisorCheckSummariesRequest);
            }
        });
    }

    @Override
    public Future<DescribeTrustedAdvisorCheckSummariesResult> describeTrustedAdvisorCheckSummariesAsync(final DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest, final AsyncHandler<DescribeTrustedAdvisorCheckSummariesRequest, DescribeTrustedAdvisorCheckSummariesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrustedAdvisorCheckSummariesResult>(){

            @Override
            public DescribeTrustedAdvisorCheckSummariesResult call() throws Exception {
                DescribeTrustedAdvisorCheckSummariesResult result;
                try {
                    result = AWSSupportAsyncClient.this.describeTrustedAdvisorCheckSummaries(describeTrustedAdvisorCheckSummariesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTrustedAdvisorCheckSummariesRequest, (Object)result);
                return result;
            }
        });
    }
}

