/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.HomeDirectoryMapEntry;
import com.amazonaws.services.transfer.model.HomeDirectoryType;
import com.amazonaws.services.transfer.model.PosixProfile;
import com.amazonaws.services.transfer.model.transform.DescribedAccessMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribedAccess
implements Serializable,
Cloneable,
StructuredPojo {
    private String homeDirectory;
    private List<HomeDirectoryMapEntry> homeDirectoryMappings;
    private String homeDirectoryType;
    private String policy;
    private PosixProfile posixProfile;
    private String role;
    private String externalId;

    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public DescribedAccess withHomeDirectory(String homeDirectory) {
        this.setHomeDirectory(homeDirectory);
        return this;
    }

    public List<HomeDirectoryMapEntry> getHomeDirectoryMappings() {
        return this.homeDirectoryMappings;
    }

    public void setHomeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
        if (homeDirectoryMappings == null) {
            this.homeDirectoryMappings = null;
            return;
        }
        this.homeDirectoryMappings = new ArrayList<HomeDirectoryMapEntry>(homeDirectoryMappings);
    }

    public DescribedAccess withHomeDirectoryMappings(HomeDirectoryMapEntry ... homeDirectoryMappings) {
        if (this.homeDirectoryMappings == null) {
            this.setHomeDirectoryMappings(new ArrayList<HomeDirectoryMapEntry>(homeDirectoryMappings.length));
        }
        for (HomeDirectoryMapEntry ele : homeDirectoryMappings) {
            this.homeDirectoryMappings.add(ele);
        }
        return this;
    }

    public DescribedAccess withHomeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
        this.setHomeDirectoryMappings(homeDirectoryMappings);
        return this;
    }

    public void setHomeDirectoryType(String homeDirectoryType) {
        this.homeDirectoryType = homeDirectoryType;
    }

    public String getHomeDirectoryType() {
        return this.homeDirectoryType;
    }

    public DescribedAccess withHomeDirectoryType(String homeDirectoryType) {
        this.setHomeDirectoryType(homeDirectoryType);
        return this;
    }

    public DescribedAccess withHomeDirectoryType(HomeDirectoryType homeDirectoryType) {
        this.homeDirectoryType = homeDirectoryType.toString();
        return this;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getPolicy() {
        return this.policy;
    }

    public DescribedAccess withPolicy(String policy) {
        this.setPolicy(policy);
        return this;
    }

    public void setPosixProfile(PosixProfile posixProfile) {
        this.posixProfile = posixProfile;
    }

    public PosixProfile getPosixProfile() {
        return this.posixProfile;
    }

    public DescribedAccess withPosixProfile(PosixProfile posixProfile) {
        this.setPosixProfile(posixProfile);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public DescribedAccess withRole(String role) {
        this.setRole(role);
        return this;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public DescribedAccess withExternalId(String externalId) {
        this.setExternalId(externalId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHomeDirectory() != null) {
            sb.append("HomeDirectory: ").append(this.getHomeDirectory()).append(",");
        }
        if (this.getHomeDirectoryMappings() != null) {
            sb.append("HomeDirectoryMappings: ").append(this.getHomeDirectoryMappings()).append(",");
        }
        if (this.getHomeDirectoryType() != null) {
            sb.append("HomeDirectoryType: ").append(this.getHomeDirectoryType()).append(",");
        }
        if (this.getPolicy() != null) {
            sb.append("Policy: ").append(this.getPolicy()).append(",");
        }
        if (this.getPosixProfile() != null) {
            sb.append("PosixProfile: ").append(this.getPosixProfile()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getExternalId() != null) {
            sb.append("ExternalId: ").append(this.getExternalId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedAccess)) {
            return false;
        }
        DescribedAccess other = (DescribedAccess)obj;
        if (other.getHomeDirectory() == null ^ this.getHomeDirectory() == null) {
            return false;
        }
        if (other.getHomeDirectory() != null && !other.getHomeDirectory().equals(this.getHomeDirectory())) {
            return false;
        }
        if (other.getHomeDirectoryMappings() == null ^ this.getHomeDirectoryMappings() == null) {
            return false;
        }
        if (other.getHomeDirectoryMappings() != null && !other.getHomeDirectoryMappings().equals(this.getHomeDirectoryMappings())) {
            return false;
        }
        if (other.getHomeDirectoryType() == null ^ this.getHomeDirectoryType() == null) {
            return false;
        }
        if (other.getHomeDirectoryType() != null && !other.getHomeDirectoryType().equals(this.getHomeDirectoryType())) {
            return false;
        }
        if (other.getPolicy() == null ^ this.getPolicy() == null) {
            return false;
        }
        if (other.getPolicy() != null && !other.getPolicy().equals(this.getPolicy())) {
            return false;
        }
        if (other.getPosixProfile() == null ^ this.getPosixProfile() == null) {
            return false;
        }
        if (other.getPosixProfile() != null && !other.getPosixProfile().equals(this.getPosixProfile())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getExternalId() == null ^ this.getExternalId() == null) {
            return false;
        }
        return other.getExternalId() == null || other.getExternalId().equals(this.getExternalId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHomeDirectory() == null ? 0 : this.getHomeDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getHomeDirectoryMappings() == null ? 0 : this.getHomeDirectoryMappings().hashCode());
        hashCode = 31 * hashCode + (this.getHomeDirectoryType() == null ? 0 : this.getHomeDirectoryType().hashCode());
        hashCode = 31 * hashCode + (this.getPolicy() == null ? 0 : this.getPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getPosixProfile() == null ? 0 : this.getPosixProfile().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getExternalId() == null ? 0 : this.getExternalId().hashCode());
        return hashCode;
    }

    public DescribedAccess clone() {
        try {
            return (DescribedAccess)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DescribedAccessMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

