/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.transfer.model.WorkflowDetails;
import java.util.List;

@SdkInternalApi
public class WorkflowDetailsMarshaller {
    private static final MarshallingInfo<List> ONUPLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OnUpload").build();
    private static final MarshallingInfo<List> ONPARTIALUPLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OnPartialUpload").build();
    private static final WorkflowDetailsMarshaller instance = new WorkflowDetailsMarshaller();

    public static WorkflowDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(WorkflowDetails workflowDetails, ProtocolMarshaller protocolMarshaller) {
        if (workflowDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(workflowDetails.getOnUpload(), ONUPLOAD_BINDING);
            protocolMarshaller.marshall(workflowDetails.getOnPartialUpload(), ONPARTIALUPLOAD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

