/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.repository.descriptors.IdDisplay;
import java.io.File;
import java.util.Locale;

public class SystemImage
implements ISystemImage {
    public static final String ANDROID_PREFIX = "android-";
    public static final IdDisplay DEFAULT_TAG = new IdDisplay("default", "Default");
    private final ISystemImage.LocationType mLocationtype;
    private final IdDisplay mTag;
    private final String mAbiType;
    private final File mLocation;
    private final File[] mSkins;

    public SystemImage(@NonNull File location, @NonNull ISystemImage.LocationType locationType, @NonNull IdDisplay tag, @NonNull String abiType, @NonNull File[] skins) {
        this.mLocation = location;
        this.mLocationtype = locationType;
        this.mTag = tag;
        this.mAbiType = abiType;
        this.mSkins = skins;
    }

    public SystemImage(@NonNull SdkManager sdkManager, @NonNull IAndroidTarget target, @NonNull ISystemImage.LocationType locationType, @NonNull IdDisplay tag, @NonNull String abiType, @NonNull File[] skins) {
        this.mLocationtype = locationType;
        this.mTag = tag;
        this.mAbiType = abiType;
        this.mSkins = skins;
        File location = null;
        switch (locationType) {
            case IN_PLATFORM_LEGACY: {
                location = new File(target.getLocation(), SdkConstants.OS_IMAGES_FOLDER);
                break;
            }
            case IN_PLATFORM_SUBFOLDER: {
                location = FileOp.append(target.getLocation(), SdkConstants.OS_IMAGES_FOLDER, abiType);
                break;
            }
            case IN_SYSTEM_IMAGE: {
                if (!target.isPlatform()) {
                    throw new IllegalArgumentException("Add-ons do not support the system-image location type");
                }
                location = SystemImage.getCanonicalFolder(sdkManager.getLocation(), target.getVersion(), tag.getId(), abiType);
                break;
            }
            default: {
                assert (false) : "SystemImage used with an incorrect locationType";
                break;
            }
        }
        this.mLocation = location;
    }

    @NonNull
    public static File getCanonicalFolder(String sdkOsPath, AndroidVersion platformVersion, String tagId, String abiType) {
        File root = FileOp.append(sdkOsPath, "system-images", ANDROID_PREFIX + platformVersion.getApiString());
        if (tagId != null) {
            root = FileOp.append(root, tagId);
        }
        if (abiType == null) {
            return root;
        }
        return FileOp.append(root, abiType);
    }

    @Override
    @NonNull
    public File getLocation() {
        return this.mLocation;
    }

    @Override
    @NonNull
    public ISystemImage.LocationType getLocationType() {
        return this.mLocationtype;
    }

    @Override
    @NonNull
    public IdDisplay getTag() {
        return this.mTag;
    }

    @Override
    @NonNull
    public String getAbiType() {
        return this.mAbiType;
    }

    @Override
    public File[] getSkins() {
        return this.mSkins;
    }

    @Override
    public int compareTo(ISystemImage other) {
        int t = this.getTag().compareTo(other.getTag());
        if (t != 0) {
            return t;
        }
        return this.getAbiType().compareToIgnoreCase(other.getAbiType());
    }

    @NonNull
    public String toString() {
        return String.format("SystemImage tag=%s, ABI=%s, location %s='%s'", this.mTag.getId(), this.mAbiType, this.mLocationtype.toString().replace('_', ' ').toLowerCase(Locale.US), this.mLocation);
    }
}

