/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Meta;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class Device {
    @NonNull
    private final String mName;
    @NonNull
    private final String mId;
    @NonNull
    private final String mManufacturer;
    @NonNull
    private final List<Software> mSoftware;
    @NonNull
    private final List<State> mState;
    @NonNull
    private final Meta mMeta;
    @NonNull
    private final State mDefaultState;
    @Nullable
    private String mTagId;
    @NonNull
    private Map<String, String> mBootProps;

    @Deprecated
    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public String getDisplayName() {
        return this.mName;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public String getManufacturer() {
        return this.mManufacturer;
    }

    @NonNull
    public List<Software> getAllSoftware() {
        return this.mSoftware;
    }

    @NonNull
    public List<State> getAllStates() {
        return this.mState;
    }

    @NonNull
    public Hardware getDefaultHardware() {
        return this.mDefaultState.getHardware();
    }

    @NonNull
    public Meta getMeta() {
        return this.mMeta;
    }

    @NonNull
    public State getDefaultState() {
        return this.mDefaultState;
    }

    @Nullable
    public Software getSoftware(int apiVersion) {
        for (Software s : this.mSoftware) {
            if (apiVersion < s.getMinSdkLevel() || apiVersion > s.getMaxSdkLevel()) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public State getState(String name) {
        for (State s : this.getAllStates()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public Dimension getScreenSize(@NonNull ScreenOrientation orientation) {
        int screenHeight;
        int screenWidth;
        int y;
        Screen screen = this.getDefaultHardware().getScreen();
        if (screen == null) {
            return null;
        }
        int x = screen.getXDimension();
        if (x > (y = screen.getYDimension())) {
            if (orientation == ScreenOrientation.LANDSCAPE) {
                screenWidth = x;
                screenHeight = y;
            } else {
                screenWidth = y;
                screenHeight = x;
            }
        } else if (orientation == ScreenOrientation.LANDSCAPE) {
            screenWidth = y;
            screenHeight = x;
        } else {
            screenWidth = x;
            screenHeight = y;
        }
        return new Dimension(screenWidth, screenHeight);
    }

    @Nullable
    public String getTagId() {
        return this.mTagId;
    }

    public Map<String, String> getBootProps() {
        return this.mBootProps;
    }

    private Device(Builder b) {
        this.mName = b.mName;
        this.mId = b.mId;
        this.mManufacturer = b.mManufacturer;
        this.mSoftware = Collections.unmodifiableList(b.mSoftware);
        this.mState = Collections.unmodifiableList(b.mState);
        this.mMeta = b.mMeta;
        this.mDefaultState = b.mDefaultState;
        this.mTagId = b.mTagId;
        this.mBootProps = Collections.unmodifiableMap(b.mBootProps);
    }

    public boolean equals(Object o) {
        boolean ok;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device d = (Device)o;
        boolean bl = ok = this.mName.equals(d.getDisplayName()) && this.mManufacturer.equals(d.getManufacturer()) && ((Object)this.mSoftware).equals(d.getAllSoftware()) && ((Object)this.mState).equals(d.getAllStates()) && this.mMeta.equals(d.getMeta()) && this.mDefaultState.equals(d.getDefaultState());
        if (!ok) {
            return false;
        }
        boolean bl2 = ok = this.mTagId == null && d.mTagId == null || this.mTagId != null && this.mTagId.equals(d.mTagId);
        if (!ok) {
            return false;
        }
        ok = this.mBootProps == null && d.mBootProps == null || this.mBootProps != null && ((Object)this.mBootProps).equals(d.mBootProps);
        return ok;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.mName.hashCode();
        hash = 31 * hash + this.mManufacturer.hashCode();
        hash = 31 * hash + ((Object)this.mSoftware).hashCode();
        hash = 31 * hash + ((Object)this.mState).hashCode();
        hash = 31 * hash + this.mMeta.hashCode();
        hash = 31 * hash + this.mDefaultState.hashCode();
        if (this.mTagId != null) {
            hash = 31 * hash + this.mTagId.hashCode();
        }
        if (this.mBootProps != null && !this.mBootProps.isEmpty()) {
            hash = 31 * hash + ((Object)this.mBootProps).hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Device [mName=");
        sb.append(this.mName);
        sb.append(", mId=");
        sb.append(this.mId);
        sb.append(", mManufacturer=");
        sb.append(this.mManufacturer);
        sb.append(", mSoftware=");
        sb.append(this.mSoftware);
        sb.append(", mState=");
        sb.append(this.mState);
        sb.append(", mMeta=");
        sb.append(this.mMeta);
        sb.append(", mDefaultState=");
        sb.append(this.mDefaultState);
        sb.append(", mTagId=");
        sb.append(this.mTagId);
        sb.append(", mBootProps=");
        sb.append(this.mBootProps);
        sb.append("]");
        return sb.toString();
    }

    public static class Builder {
        private String mName;
        private String mId;
        private String mManufacturer;
        private final List<Software> mSoftware = new ArrayList<Software>();
        private final List<State> mState = new ArrayList<State>();
        private Meta mMeta;
        private State mDefaultState;
        private String mTagId;
        private final Map<String, String> mBootProps = new TreeMap<String, String>();

        public Builder() {
        }

        public Builder(Device d) {
            this.mTagId = null;
            this.mName = d.getDisplayName();
            this.mId = d.getId();
            this.mManufacturer = d.getManufacturer();
            for (Software software : d.getAllSoftware()) {
                this.mSoftware.add(software.deepCopy());
            }
            for (State state : d.getAllStates()) {
                this.mState.add(state.deepCopy());
            }
            this.mSoftware.addAll(d.getAllSoftware());
            this.mState.addAll(d.getAllStates());
            this.mMeta = d.getMeta();
            this.mDefaultState = d.getDefaultState();
        }

        public void setName(@NonNull String name) {
            this.mName = name;
        }

        public void setId(@NonNull String id) {
            this.mId = id;
        }

        public void setTagId(@Nullable String tagId) {
            this.mTagId = tagId;
        }

        public void addBootProp(@NonNull String propName, @NonNull String propValue) {
            this.mBootProps.put(propName, propValue);
        }

        public void setManufacturer(@NonNull String manufacturer) {
            this.mManufacturer = manufacturer;
        }

        public void addSoftware(@NonNull Software sw) {
            this.mSoftware.add(sw);
        }

        public void addAllSoftware(@NonNull Collection<? extends Software> sw) {
            this.mSoftware.addAll(sw);
        }

        public void addState(State state) {
            this.mState.add(state);
        }

        public void addAllState(@NonNull Collection<? extends State> states) {
            this.mState.addAll(states);
        }

        public boolean removeState(@NonNull String stateName) {
            for (int i = 0; i < this.mState.size(); ++i) {
                if (stateName == null || !stateName.equals(this.mState.get(i).getName())) continue;
                this.mState.remove(i);
                return true;
            }
            return false;
        }

        public void setMeta(@NonNull Meta meta) {
            this.mMeta = meta;
        }

        public Device build() {
            if (this.mName == null) {
                throw this.generateBuildException("Device missing name");
            }
            if (this.mManufacturer == null) {
                throw this.generateBuildException("Device missing manufacturer");
            }
            if (this.mSoftware.size() <= 0) {
                throw this.generateBuildException("Device software not configured");
            }
            if (this.mState.size() <= 0) {
                throw this.generateBuildException("Device states not configured");
            }
            if (this.mId == null) {
                this.mId = this.mName;
            }
            if (this.mMeta == null) {
                this.mMeta = new Meta();
            }
            for (State s : this.mState) {
                if (!s.isDefaultState()) continue;
                this.mDefaultState = s;
                break;
            }
            if (this.mDefaultState == null) {
                throw this.generateBuildException("Device missing default state");
            }
            return new Device(this);
        }

        private IllegalStateException generateBuildException(String err) {
            String device = "";
            if (this.mManufacturer != null) {
                device = this.mManufacturer + ' ';
            }
            device = this.mName != null ? device + this.mName : "Unknown " + device + "Device";
            return new IllegalStateException("Error building " + device + ": " + err);
        }
    }
}

